unit uDBCheckBox;

interface

uses
  DB,
{$IFDEF VCL}
  DBCtrls,
{$ELSE}
  QDBCtrls,
{$ENDIF}
  Rubies;

type
  TPhi_DBCheckBox = class(TDBCheckBox)
//  published
//    property Text;
  end;

var
  cDBCheckBox: Tvalue;

function ap_iDBCheckBox(real: TPhi_DBCheckBox; owner: Tvalue): Tvalue;
procedure Init_DBCheckBox;

implementation

uses uDefUtils, Pythia, uRDB;

procedure DBCheckBox_setup(obj: Tvalue; real: TPhi_DBCheckBox);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBCheckBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBCheckBox_alloc(This: Tvalue; real: TPhi_DBCheckBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBCheckBox_setup(result, real);
end;

function ap_iDBCheckBox(real: TPhi_DBCheckBox; owner: Tvalue): Tvalue;
begin
  result := DBCheckBox_alloc(cDBCheckBox, real);
  ap_owner(result, owner);
end;

function ap_iDBCheckBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBCheckBox(TPhi_DBCheckBox(AControl), owner)
end;

function DBCheckBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBCheckBox;
begin
  real := TPhi_DBCheckBox.Create(nil);
  result := CompoAlloc(This, real);
  DBCheckBox_setup(result, real);
end;

function DBCheckBox_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBCheckBox;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  result := v;
end;

function DBCheckBox_set_data_field(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBCheckBox;
begin
  real := ap_data_get_struct(This);
  real.DataField := dl_String(v);
  result := v;
end;

procedure Init_DBCheckBox;
begin
  cDBCheckBox := DefinePersistentClass(mRDB, TPhi_DBCheckBox, ap_cCheckBox, ap_iDBCheckBox_v);
  rb_define_method(cDBCheckBox, 'event_handle', @DBCheckBox_event_handle, 1);
  rb_define_alloc_func(cDBCheckBox, @DBCheckBox_allocate);
  DefineAttrSet(cDBCheckBox, 'data_source', DBCheckBox_set_data_source);
  DefineAttrSet(cDBCheckBox, 'data_field', DBCheckBox_set_data_field);
end;

end.
