unit uDBGrid;

interface

uses
  DB,
{$IFDEF VCL}
  DBGrids,
{$ELSE}
  QDBGrids,
{$ENDIF}
  Rubies;

type
  TPhi_DBGrid = class(TDBGrid)
  published
    property OnMouseWheel;
    property OnMouseWheelUp;
    property OnMouseWheelDown;
  end;

var
  cDBGrid: Tvalue;

function ap_iDBGrid(real: TPhi_DBGrid; owner: Tvalue): Tvalue;
procedure Init_DBGrid;

implementation

uses
  Classes,  // TShiftState BasicAction TAlignment
  SysUtils,
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  uDefUtils, Pythia, uRDB, uColumn, uField;

procedure DBGrid_setup(obj: Tvalue; real: TPhi_DBGrid);
begin
//  rb_iv_set(obj, '@columns', ap_iColumns(real.Columns, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
  rb_iv_set(obj, '@title_font', ap_iFont(real.TitleFont, obj));
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.constraints, obj));
//    AssignPropMethod(real, [Handle, PhiGetHandle]);
end;

function DBGrid_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle, PhiGetHandle]);
  result := Qnil;
end;

function DBGrid_alloc(This: Tvalue; real: TPhi_DBGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  DBGrid_setup(result, real);
  ap_obj_call_init(result, 0, nil);
end;

function ap_iDBGrid(real: TPhi_DBGrid; owner: Tvalue): Tvalue;
begin
  result := DBGrid_alloc(cDBGrid, real);
  ap_owner(result, owner);
end;

function ap_iDBGrid_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iDBGrid(TPhi_DBGrid(AControl), owner)
end;

function DBGrid_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := TPhi_DBGrid.Create(nil);
  result := CompoAlloc(This, real);
  DBGrid_setup(result, real);
end;

function DBGrid_get_columns(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_iColumns(real.Columns, This);
end;

function DBGrid_set_data_source(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  DataSource: TDataSource;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TDataSource, DataSource);
  real.DataSource := DataSource;
  rb_iv_set(This, '@data_source', v);
  result := v;
end;

function DBGrid_get_field_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.FieldCount);
end;

function DBGrid_get_fields(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  i:integer;
begin
  real := ap_data_get_struct(This);
  result := rb_ary_new;
  try
    for i := 0 to real.FieldCount-1 do
    begin
      rb_ary_push(result, ap_iField(real.Fields[i], This));
    end;
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

function DBGrid_get_selected_field(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  result := Qnil;
  real := ap_data_get_struct(This);
  try
    result := ap_iField(real.SelectedField, This);
  except
    on E: Exception do
      ap_raise(ap_eDatabaseError, E.message);
  end;
end;

// move to uGrid.pas left_col scroll_bars

function DBGrid_get_selected_index(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(ord(real.SelectedIndex));
end;

function DBGrid_set_selected_index(This,v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  try
    real.SelectedIndex := dl_Integer(v);
  except
    ap_raise(ap_eArgError, sOut_of_range);
  end;
  result := v;
end;

// move to uGrid.pas row top_row row_heights row_count visible_row_count

(**** str_method made by ap_src_maker ****)

function DBGrid_raw_to_data_column(This, ACol : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_ACol : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  result := ap_Integer(real.RawToDataColumn( dlv_ACol ));
end;

function DBGrid_data_to_raw_column(This, ACol : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_ACol : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  result := ap_Integer(real.DataToRawColumn( dlv_ACol ));
end;

function DBGrid_acquire_layout_lock(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.AcquireLayoutLock);
end;

function DBGrid_begin_layout(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.BeginLayout;
  result := This;
end;

function DBGrid_begin_update(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.BeginUpdate;
  result := This;
end;

function DBGrid_cancel_layout(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.CancelLayout;
  result := This;
end;

function DBGrid_calc_title_rect(This, Col, ARow, MasterCol : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_Col : TColumn;
  dlv_ARow : Integer;
  dlv_MasterCol : TColumn;
begin
  real := ap_data_get_struct(This);
  dlv_Col := ap_data_get_struct(Col);
  dlv_ARow := dl_Integer(ARow);
  dlv_MasterCol := ap_data_get_struct(MasterCol);
  result := ap_iRect(real.CalcTitleRect( dlv_Col, dlv_ARow, dlv_MasterCol ),This);
end;

function DBGrid_column_at_depth(This, Col, ADepth : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_Col : TColumn;
  dlv_ADepth : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_Col := ap_data_get_struct(Col);
  dlv_ADepth := dl_Integer(ADepth);
  result := ap_iColumn(real.ColumnAtDepth( dlv_Col, dlv_ADepth ),This);
end;

function DBGrid_defer_layout(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.DeferLayout;
  result := This;
end;

function DBGrid_define_field_map(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.DefineFieldMap;
  result := This;
end;

function DBGrid_end_layout(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.EndLayout;
  result := This;
end;

function DBGrid_end_update(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.EndUpdate;
  result := This;
end;

function DBGrid_get_col_field(This, DataCol : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_DataCol : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_DataCol := dl_Integer(DataCol);
  result := ap_iField(real.GetColField( dlv_DataCol ),This);
end;

function DBGrid_get_field_value(This, ACol : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_ACol : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  result := ap_String(real.GetFieldValue( dlv_ACol ));
end;

function DBGrid_invalidate_titles(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.InvalidateTitles;
  result := This;
end;

function DBGrid_layout_changed(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.LayoutChanged;
  result := This;
end;

function DBGrid_link_active(This, Value : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_Value : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_Value := dl_Boolean(Value);
  real.LinkActive( dlv_Value );
  result := This;
end;

function DBGrid_loaded(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.Loaded;
  result := This;
end;

function DBGrid_scroll(This, Distance : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_Distance : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_Distance := dl_Integer(Distance);
  real.Scroll( dlv_Distance );
  result := This;
end;

function DBGrid_set_column_attributes(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  real.SetColumnAttributes;
  result := This;
end;

function DBGrid_set_edit_text(This, ACol, ARow, Value : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_ACol : Longint;
  dlv_ARow : Longint;
  dlv_Value : string;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  dlv_ARow := dl_Integer(ARow);
  dlv_Value := dl_String(Value);
  real.SetEditText( dlv_ACol, dlv_ARow, dlv_Value );
  result := This;
end;

function DBGrid_store_columns(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.StoreColumns);
end;

function DBGrid_valid_field_index(This, FieldIndex : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_FieldIndex : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_FieldIndex := dl_Integer(FieldIndex);
  result := ap_Bool(real.ValidFieldIndex( dlv_FieldIndex ));
end;

function DBGrid_use_right_to_left_alignment_for_field(This, AField, Alignment : Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
  dlv_AField : TField;
  dlv_Alignment : TAlignment;
begin
  real := ap_data_get_struct(This);
  dlv_AField := ap_data_get_struct(AField);
  dlv_Alignment := TAlignment(dl_Integer(Alignment));
  result := ap_Bool(real.UseRightToLeftAlignmentForField( dlv_AField, dlv_Alignment ));
end;

function DBGrid_get_indicator_offset(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.IndicatorOffset);
end;

function DBGrid_get_layout_lock(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.LayoutLock);
end;

function DBGrid_get_update_lock(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_DBGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.UpdateLock);
end;

(**** made by ap_src_maker ****)

procedure Init_DBGrid;
begin
  DefineConstSetType(mRDB, TypeInfo(TDBGridOption));

  cDBGrid := DefinePersistentClass(mRDB, TPhi_DBGrid, ap_cCustomGrid, ap_iDBGrid_v);
  rb_define_method(cDBGrid, 'event_handle', @DBGrid_event_handle, 1);
  rb_define_alloc_func(cDBGrid, DBGrid_allocate);
  DefineAttrGet(cDBGrid, 'columns', DBGrid_get_columns);
  DefineAttrSet(cDBGrid, 'data_source', DBGrid_set_data_source);
  DefineAttrGet(cDBGrid, 'field_count', DBGrid_get_field_count);
  DefineAttrGet(cDBGrid, 'fields', DBGrid_get_fields);
  DefineAttrGet(cDBGrid, 'selected_field', DBGrid_get_selected_field);
  rb_define_attr(cDBGrid, 'canvas', 1, 0);
  DefineAttrGet(cDBGrid, 'selected_index', DBGrid_get_selected_index);
  DefineAttrSet(cDBGrid, 'selected_index', DBGrid_set_selected_index);
//  move to CustomGrid (left_col scroll_bars row top_row row_heights row_count visible_row_count)

(**** str_init made by ap_src_maker ****)
  rb_define_method(cDBGrid, 'raw_to_data_column', @DBGrid_raw_to_data_column, 1);
  rb_define_method(cDBGrid, 'data_to_raw_column', @DBGrid_data_to_raw_column, 1);
  rb_define_method(cDBGrid, 'acquire_layout_lock', @DBGrid_acquire_layout_lock, 0);
  rb_define_method(cDBGrid, 'begin_layout', @DBGrid_begin_layout, 0);
  rb_define_method(cDBGrid, 'begin_update', @DBGrid_begin_update, 0);
  rb_define_method(cDBGrid, 'cancel_layout', @DBGrid_cancel_layout, 0);
  rb_define_method(cDBGrid, 'calc_title_rect', @DBGrid_calc_title_rect, 3);
  rb_define_method(cDBGrid, 'column_at_depth', @DBGrid_column_at_depth, 2);
  rb_define_method(cDBGrid, 'defer_layout', @DBGrid_defer_layout, 0);
  rb_define_method(cDBGrid, 'define_field_map', @DBGrid_define_field_map, 0);
  rb_define_method(cDBGrid, 'end_layout', @DBGrid_end_layout, 0);
  rb_define_method(cDBGrid, 'end_update', @DBGrid_end_update, 0);
  rb_define_method(cDBGrid, 'get_col_field', @DBGrid_get_col_field, 1);
  rb_define_method(cDBGrid, 'get_field_value', @DBGrid_get_field_value, 1);
  rb_define_method(cDBGrid, 'invalidate_titles', @DBGrid_invalidate_titles, 0);
  rb_define_method(cDBGrid, 'layout_changed', @DBGrid_layout_changed, 0);
  rb_define_method(cDBGrid, 'link_active', @DBGrid_link_active, 1);
  rb_define_method(cDBGrid, 'loaded', @DBGrid_loaded, 0);
  rb_define_method(cDBGrid, 'scroll', @DBGrid_scroll, 1);
  rb_define_method(cDBGrid, 'set_column_attributes', @DBGrid_set_column_attributes, 0);
  rb_define_method(cDBGrid, 'set_edit_text', @DBGrid_set_edit_text, 3);
  rb_define_method(cDBGrid, 'store_columns', @DBGrid_store_columns, 0);
  rb_define_method(cDBGrid, 'valid_field_index', @DBGrid_valid_field_index, 1);
  rb_define_method(cDBGrid, 'use_right_to_left_alignment_for_field', @DBGrid_use_right_to_left_alignment_for_field, 2);
  DefineAttrGet(cDBGrid, 'indicator_offset', DBGrid_get_indicator_offset);
  DefineAttrGet(cDBGrid, 'layout_lock', DBGrid_get_layout_lock);
  DefineAttrGet(cDBGrid, 'update_lock', DBGrid_get_update_lock);
(**** made by ap_src_maker ****)

end;

end.
