require 'test/unit'
require 'phi'

module Phi
	class ListItem
		def inspect
			"#<#{self.class}:#{'0x%x'%self.object_id} caption=#{self.caption.inspect}>"
		end
	end
end

class TCListView < Test::Unit::TestCase

=begin

FindCaption \bh́Cw肳ꂽLvṼXgr[ڂꍇɂԂ܂B

function FindCaption(StartIndex: Integer; Value: string; Partial, Inclusive, Wrap: Boolean): TListItem;



FindCaption \bhĂяoƁCValue p[^Ŏw肵ŃxtꂽXgr[ڂł܂B

Inclusive p[^ True ̏ꍇCStartIndex Ŏw肵Xgڂ猟n܂܂B
ȊȌꍇC͎̍ڂJn܂B

Wrap p[^ True ̏ꍇCv鍀ڂȂΐ擪ɖ߂Čs܂B
FindCaption ́CValue ɓ Caption vpeBŏ̍ڂԂ܂B

Partial p[^ True ̏ꍇCCaption  Value Ŏn܂ĂΌo܂B
Partial p[^ False ̏ꍇCCaption  Value ƐmɈvȂ΂Ȃ܂B

v鍀ڂȂꍇCFindCaption  nil Ԃ܂B

=end
	def test_find_caption
		form = Phi::Form.new
		lv = Phi::ListView.new(form)
		
		# lv.find_caption(nil)
		#=> ArgumentError: wrong number of arguments (1 for 5)
		
		# lv.find_caption(0,nil,false,false,false)
		#=> TypeError: wrong argument type nil (expected String)
		
		assert_nil(lv.find_caption(0,'',false,false,false))
		
		# ACe1ǉ
		item = lv.items.add
		item.caption = "abc"
		
		assert_nil(lv.find_caption(0,'',false,false,false))
		
		# inclusive p[^̃eXg
		assert_equal(item, lv.find_caption(-1,'abc',false,false,false))
		assert_equal(item, lv.find_caption(0,'abc',false,true,false))
		assert_nil(lv.find_caption(0,'abc',false,false,false))
		
		# inclusive, partial p[^̃eXg
		assert_nil(lv.find_caption(-1,'ab',false,false,false))
		assert_nil(lv.find_caption(0,'ab',false,true,false))
		
		assert_equal(item, lv.find_caption(-1,'ab',true,false,false))
		assert_equal(item, lv.find_caption(0,'ab',true,true,false))
		assert_nil(lv.find_caption(0,'ab',true,false,false))
		
		# LvV󕶎ɂ
		item.caption = ""
		
		# inclusive p[^̃eXg
		assert_equal(item, lv.find_caption(-1,'',false,false,false))
		assert_equal(item, lv.find_caption(0,'',false,true,false))
		assert_nil(lv.find_caption(0,'',false,false,false))
		
		# ACe1ǉ()
		item2 = lv.items.add
		item2.caption = "abc"
		
		# inclusive p[^̃eXg
		assert_equal(item2, lv.find_caption(0,'abc',false,false,false))
		assert_equal(item2, lv.find_caption(1,'abc',false,true,false))
		assert_nil(lv.find_caption(1,'abc',false,false,false))
		
		# inclusive, partial p[^̃eXg
		assert_nil(lv.find_caption(0,'ab',false,false,false))
		assert_nil(lv.find_caption(1,'ab',false,true,false))
		
		assert_equal(item2, lv.find_caption(0,'ab',true,false,false))
		assert_equal(item2, lv.find_caption(1,'ab',true,true,false))
		assert_nil(lv.find_caption(1,'ab',true,false,false))
		
		# start_index p[^̃eXg
		assert_equal(item, lv.find_caption(-1,'',false,false,false))
		assert_equal(item, lv.find_caption(0,'',false,true,false))
		assert_nil(lv.find_caption(0,'',false,false,false))
		
		# start_index, wrap p[^̃eXg
		assert_nil(lv.find_caption(0,'',false,false,false))
		assert_nil(lv.find_caption(1,'',false,true,false))
		assert_nil(lv.find_caption(1,'',false,false,false))
		
		assert_equal(item, lv.find_caption(0,'',false,false,true))
		assert_equal(item, lv.find_caption(1,'',false,true,true))
		assert_equal(item, lv.find_caption(1,'',false,false,true))
		
	end

=begin

FindData

Apolloł TListItem.Data ɂ͑ΉRubyIuWFNg Tvalue li[B
ListItem#data  TListItem.Data Ƃ͌тĂȂB
Ȃ̂ŁAListView#find_data  TListView.FindData ɎĂ̈Ӗł͎gȂB

=end

=begin

OwnerData

TListView.OwnerData := True ɂē삪ω郁\bhmFĂ݂B

$(Delphi6)\Source\Vcl\ComCtrls.pas:

function TListItem.GetChecked: Boolean;
begin
  with Owner.Owner do
    if not OwnerData and HandleAllocated then
      Result := (ListView_GetCheckState(Handle, Index) <> 0)
    else
      Result := FChecked;
end;

ɂ Checked vpeB OwnerData = True ̂Ƃ FChecked ̒lԂB

procedure TListItem.SetChecked(Value: Boolean);
var
  LV: TCustomListView;
begin
  if Value <> Checked then
  begin
    FChecked := Value;
    LV := Owner.Owner;
    if not LV.OwnerData and LV.HandleAllocated then
      ListView_SetCheckState(LV.Handle, Index, Value);
  end;
end;

ݒ肷ق OwnerData Ɋւ炸 FCheck ݒ肷B
OwnerData = True ̂Ƃ TListItem  sengleton ɂȂ邩A
OwnerData = True ̂Ƃ TListItem.Checked ̓ACëႢɂ炸ɓlԂ͂łB

----
Checked vpeB́CXgڂׂ̗Ƀ`FbN}[N\邩ǂw肵܂B

property Checked: Boolean;



Checked vpeB́CXgڂCIĂIvVXgr[ŃXgڂׂ̗Ƀ`FbN}[Ntĕ\邩ǂwł܂BChecked  True Ȃ΁Cڂׂ̗Ƀ`FbN}[N\܂BChecked  False Ȃ΁C`FbN}[N͕\܂B

	Checked vpeBgpOɁCListView  CheckBoxes vpeB True ɐݒ肵ĂB
----

=end

	def test_owner_data
		form = Phi::Form.new
		lv = Phi::ListView.new(form)
# lv.owner_draw = true
		assert_equal(false, lv.owner_data)
		lv.owner_data = true
		assert_equal(true, lv.owner_data)
		
		# Delphi6 wvł͌o CheckBoxes ɂȂĂ邪 Checkboxes ̌łB
		assert_equal(false, lv.checkboxes)
		lv.checkboxes = true
		assert_equal(true, lv.checkboxes)
		
		item = lv.items.add
		item.caption = "abc"
		
#	̈ʒu owner_draw ς items Iɂ܂炵 (false->true or true->false)
#	lv.owner_draw = true
#	# or lv.owner_draw = false (O lv.owner_draw = true ƂƂ)
#	p item
#	#<Phi::ListItem:0x876ff4 caption="">
#	p item.checked
#	C:/usr/lib/ruby/1.8/test/unit/autorunner.rb:20: in `checked': W[ 'vcl60.bpl' ̃AhX 4013D1FB ŃAhX 00000084 ɑ΂ǂݍ݈ᔽ܂B(EAccessViolation)
		
		assert_equal(false, item.checked)
		item.checked = true
		assert_equal(true, item.checked)
		
		item2 = lv.items.add
		item2.caption = "def"
		
		assert_equal(false, item2.checked)
		item2.checked = true
		assert_equal(true, item2.checked)
		assert_equal(true, item.checked)
		
		# TListItems.Add Ő TListItem  OwnerData = True łĂVK̃IuWFNgłB
		# TListItems.AddItem  Item p[^ nil ̂Ƃ Owner.CreateListItem ĂԁB
		item2.checked = false
		assert_equal(false, item2.checked)
		assert_equal(true, item.checked)
		
		# OwnerData = True ̂Ƃ͈vȂB
		# ListItems#[] ͏ɓIuWFNgԂB
		assert_not_equal(item, lv.items[0])
		assert_not_equal(item2, lv.items[1])
		
		# ListItems.GetItem  OwnerData = True ̂Ƃ mask = 0 Ȃ̂ (irText Ȃ̂)
		# Caption  '' ɂȂB
		assert_equal("", lv.items[0].caption)
		assert_equal("", lv.items[1].caption)
		
		tmp_item = lv.items[0]
		tmp_item.caption = "foo"
		assert_equal("foo", tmp_item.caption)
		
		assert_equal(false, tmp_item.checked)
		tmp_item.checked = true
		assert_equal(true, tmp_item.checked)
		
		# ListItems_aref  @tmp_item Ɋi[Ȃꍇ:
		# assert_equal("", lv.items[0].caption)
		# assert_equal("", lv.items[1].caption)
		# O ListItems#[] Ȃ킿 ListItems.GetItem ɂ㏑B
		# assert_equal("", tmp_item.caption)
		
		assert_equal("foo", lv.items[0].caption)
		assert_equal("foo", lv.items[1].caption)
		assert_equal("foo", tmp_item.caption)
		assert_equal(tmp_item, lv.items[0])
		assert_equal(tmp_item, lv.items[1])
		
		assert_equal(true, lv.items[0].checked)
		assert_equal(true, lv.items[1].checked)
		assert_equal(true, tmp_item.checked)
	end

end
