unit uBitBtn;

interface

uses
{$IFDEF VCL}
  Buttons,
{$ELSE}
  QButtons,
{$ENDIF}
  Rubies;

var
  cBitBtn: Tvalue;

function ap_cBitBtn: Tvalue;
function ap_iBitBtn(real: TBitBtn; owner: Tvalue): Tvalue;
procedure Init_Bitbtn;

implementation

uses
  Classes,
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  uDefUtils, uAlloc, uProp, uPhi, uBitmap,
  uPersistent, uComponent, uButton;

function ap_cBitBtn: Tvalue;
begin
  result := cBitBtn;
end;

procedure BitBtn_setup(obj: Tvalue; real: TBitBtn);
begin
  rb_iv_set(obj, '@glyph', ap_iBitmap(real.Glyph, obj));
  Button_setup(obj, real);
end;

function BitBtn_alloc(This: Tvalue; real: TBitBtn): Tvalue;
begin
  result := ChildAlloc(This, real);
  BitBtn_setup(result, real);
end;

function ap_iBitBtn(real: TBitBtn; owner: Tvalue): Tvalue;
begin
  result := BitBtn_alloc(cBitBtn, real);
  ap_owner(result, owner);
end;

function ap_iBitBtn_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iBitBtn(TBitBtn(AControl), owner);
end;

function BitBtn_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TBitBtn;
begin
  real := TBitBtn.Create(nil);
  result := CompoAlloc(This, real);
  BitBtn_setup(result, real);
end;

procedure Init_Bitbtn;
begin
  cBitBtn := OutputPersistentClass(mPhi, TBitBtn, cButton, ap_iBitBtn_v);
  rb_define_alloc_func(cBitBtn, @BitBtn_allocate);
  OutputConstSetType(mPhi, TypeInfo(TBitBtnKind));
end;

end.
