unit uCheckListBox;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  CheckLst, //++
  uIndexer,
  Rubies;

var
  cCheckListBox: Tvalue;

function ap_cCheckListBox: Tvalue;
function ap_iCheckListBox(real: TCheckListBox; owner: Tvalue): Tvalue;
procedure Init_CheckListBox;

implementation

uses
  Classes,
  uListBox,
  uConv, uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uStrings,
  uPersistent, uComponent, uControl, uButton;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_CheckListBox = class(TCheckListBox)
end;
(**** made by ap_src_maker ****)

function ap_cCheckListBox: Tvalue;
begin
  result := cCheckListBox;
end;

procedure CheckListBox_setup(obj: Tvalue; real: TCheckListBox);
begin
  rb_iv_set(obj, '@items', ap_iStrings(real.Items, obj));
//    AssignPropMethod(real, [Handle]);
end;

function CheckListBox_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function CheckListBox_alloc(This: Tvalue; real: TCheckListBox): Tvalue;
begin
  result := ChildAlloc(This, real);
  CheckListBox_setup(result, real);
end;

function ap_iCheckListBox(real: TCheckListBox; owner: Tvalue): Tvalue;
begin
  result := CheckListBox_alloc(cCheckListBox, real);
  ap_owner(result, owner);
end;

function ap_iCheckListBox_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iCheckListBox(TCheckListBox(AControl), owner)
end;

function CheckListBox_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TCheckListBox;
begin
  real := TCheckListBox.Create(nil);
  result := CompoAlloc(This, real);
  CheckListBox_setup(result, real);
end;

(**** str_method made by ap_src_maker ****)

function CheckListBox_set_checked(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.Checked[dlv_Index] := dl_Boolean(argv[1]);
  result := argv[1];
end;

function CheckListBox_get_checked(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Bool(real.Checked[dlv_Index]);
end;

function CheckListBox_set_item_enabled(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.ItemEnabled[dlv_Index] := dl_Boolean(argv[1]);
  result := argv[1];
end;

function CheckListBox_get_item_enabled(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Bool(real.ItemEnabled[dlv_Index]);
end;

function CheckListBox_set_header(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.Header[dlv_Index] := dl_Boolean(argv[1]);
  result := argv[1];
end;

function CheckListBox_get_header(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Bool(real.Header[dlv_Index]);
end;

function CheckListBox_set_state(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.State[dlv_Index] := TCheckBoxState(dl_Integer(argv[1]));
  result := argv[1];
end;

function CheckListBox_get_state(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CheckListBox;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Integer(ord(real.State[dlv_Index]));
end;

(**** made by ap_src_maker ****)


procedure Init_CheckListBox;
begin

  cCheckListBox := OutputPersistentClass(mPhi, TCheckListBox, cListBox, ap_iCheckListBox_v);
  rb_define_method(cCheckListBox, 'event_handle', @CheckListBox_event_handle, 1);
  rb_define_alloc_func(cCheckListBox, @CheckListBox_allocate);

//  OutputConstSetType(mPhi, TypeInfo(TCheckBoxState)); // defined in uCheckBox.pas
(**** str_init made by ap_src_maker ****)
  DefineIndexer(cCheckListBox, 'checked', @CheckListBox_get_checked, @CheckListBox_set_checked);
  DefineIndexer(cCheckListBox, 'item_enabled', @CheckListBox_get_item_enabled, @CheckListBox_set_item_enabled);
  DefineIndexer(cCheckListBox, 'header', @CheckListBox_get_header, @CheckListBox_set_header);
  DefineIndexer(cCheckListBox, 'state', @CheckListBox_get_state, @CheckListBox_set_state);
(**** made by ap_src_maker ****)

end;

end.
