unit uDragObject;

interface

uses
{$IFDEF VCL}
  Controls,
{$ELSE}
  QControls,
{$ENDIF}
  Rubies;

var
  cDragObject, cDragDockObject: Tvalue;

function ap_cDragObject: Tvalue;
function ap_cDragDockObject: Tvalue;
function ap_iDragObject(real: TDragObject; owner: Tvalue): Tvalue;
{$IFDEF VCL}
function ap_iDragDockObject(real: TDragDockObject; owner: Tvalue): Tvalue;
{$ENDIF}
procedure Init_DragObject;

implementation

uses uAlloc, uPhi;

function ap_cDragObject: Tvalue;
begin
  result := cDragObject;
end;

function ap_cDragDockObject: Tvalue;
begin
  result := cDragDockObject;
end;

function DragObject_alloc(This: Tvalue; real: TDragObject): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function ap_iDragObject(real: TDragObject; owner: Tvalue): Tvalue;
begin
  result := DragObject_alloc(cDragObject, real);
  ap_owner(result, owner);
end;

{$IFDEF VCL}
function DragDockObject_alloc(This: Tvalue; real: TDragDockObject): Tvalue;
begin
  result := TmpAlloc(This, real);
end;

function ap_iDragDockObject(real: TDragDockObject; owner: Tvalue): Tvalue;
begin
  result := DragDockObject_alloc(cDragDockObject, real);
  ap_owner(result, owner);
end;
{$ENDIF}

procedure Init_DragObject;
begin
  cDragObject := rb_define_class_under(mPhi, 'DragObject', ap_cObject);
  cDragDockObject := rb_define_class_under(mPhi, 'DragDockObject', cDragObject);
end;

end.
