unit uFrame;

interface

uses
{$IFDEF VCL}
  Forms,
{$ELSE}
  QForms,
{$ENDIF}
  Rubies;

var
  cFrame: Tvalue;

procedure Frame_setup(obj: Tvalue; real: TFrame);
function Frame_alloc(This: Tvalue; real: TFrame): Tvalue;
procedure Init_Frame;

implementation

uses
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

procedure Frame_setup(obj: Tvalue; real: TFrame);
begin
  rb_iv_set(obj, '@constraints', ap_iSizeConstraints(real.Constraints, obj));
//    AssignPropMethod(real, [Handle]);
end;

function Frame_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function Frame_alloc(This: Tvalue; real: TFrame): Tvalue;
begin
  result := ChildAlloc(This, real);
  Frame_setup(result, real);
end;

function ap_iFrame(real: TFrame; owner: Tvalue): Tvalue;
begin
  result := Frame_alloc(cFrame, real);
  ap_owner(result, owner);
end;

function ap_iFrame_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iFrame(TFrame(AControl), owner);
end;

function Frame_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TFrame;
begin
  real := TFrame.Create(nil);
  result := CompoAlloc(This, real);
  Frame_setup(result, real);
end;

procedure Init_Frame;
begin
  cFrame := OutputPersistentClass(mPhi, TFrame, cWinControl, ap_iFrame_v);
  rb_define_method(cFrame, 'event_handle', @Frame_event_handle, 1);
  rb_define_alloc_func(cFrame, @Frame_allocate);
end;

end.
