unit uGrid;

interface

uses
{$IFDEF VCL}
  Grids,
{$ELSE}
  QGrids,
{$ENDIF}
  Rubies;

type
TPhi_CustomGrid = class(TCustomGrid)
end;

type
  TGridDrawStateKind = (gdSelected, gdFocused, gdFixed);

var
  cCustomGrid, cDrawGrid, cStringGrid: Tvalue;

function ap_cCustomGrid: Tvalue;
function ap_cDrawGrid: Tvalue;
function ap_cStringGrid: Tvalue;
function ap_DrawGrid(real: TDrawGrid; owner: Tvalue): Tvalue;
function ap_StringGrid(real: TStringGrid; owner: Tvalue): Tvalue;
procedure Init_Grid;

implementation

uses
{$IFDEF LINUX}
  Types,
{$ENDIF}
{$IFDEF MSWINDOWS}
  Windows,
{$ENDIF}
  Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi, uConv, uIndexer,
  uSizeConstraints, uRect, uBrush, uCanvas, uFont,
  uPersistent, uComponent, uControl, uStrings;

function ap_cCustomGrid: Tvalue;
begin
  result := cCustomGrid;
end;

function CustomGrid_cell_rect(This, col, row: Tvalue): Tvalue; cdecl;
var
  real: TCustomGrid;
  rect: TRect;
begin
  real := ap_data_get_struct(This);
  rect := TDrawGrid(real).CellRect(NUM2INT(col), NUM2INT(row));
  result := ap_iRect(rect, This);
end;

function CustomGrid_mouse_coord(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TCustomGrid;
  coord: TGridCoord;
begin
  real  := ap_data_get_struct(This);
  coord := real.MouseCoord(NUM2INT(x), NUM2INT(y));
  result := rb_ary_new;
  rb_ary_push(result, INT2FIX(coord.x));
  rb_ary_push(result, INT2FIX(coord.y));
end;

function ap_cDrawGrid: Tvalue;
begin
  result := cDrawGrid;
end;

function ap_cStringGrid: Tvalue;
begin
  result := cStringGrid;
end;

procedure DrawGrid_setup(obj: Tvalue; real: TDrawGrid);
begin
  rb_iv_set(obj, '@brush', ap_iBrush(real.Brush, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function DrawGrid_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function DrawGrid_alloc(This: Tvalue; real: TDrawGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  DrawGrid_setup(result, real);
end;

function ap_DrawGrid(real: TDrawGrid; owner: Tvalue): Tvalue;
begin
  result := DrawGrid_alloc(cDrawGrid, real);
  ap_owner(result, owner);
end;

function ap_DrawGrid_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_DrawGrid(TDrawGrid(AControl), owner)
end;

function DrawGrid_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
begin
  real := TDrawGrid.Create(nil);
  result := CompoAlloc(This, real);
  DrawGrid_setup(result, real);
end;

function DrawGrid_mouse_to_cell(This, x, y: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  col, row: Longint;
begin
  real := ap_data_get_struct(This);
  real.MouseToCell(NUM2INT(x), NUM2INT(y), col, row);
  result := rb_ary_new;
  rb_ary_push(result, INT2FIX(col));
  rb_ary_push(result, INT2FIX(row));
end;

function DrawGrid_select_cell(This, cv, rv: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  col, row: Longint;
  rect: TGridRect;
begin
  real := ap_data_get_struct(This);
  col := FIX2INT(cv);
  row := FIX2INT(rv);
  if (col < 0) or (col >= real.ColCount) then
    ap_raise(ap_eArgError, sOut_of_range);
  if (row < 0) or (row >= real.RowCount) then
    ap_raise(ap_eArgError, sOut_of_range);
  rect.Top := row;
  rect.Bottom := row;
  rect.Left := col;
  rect.Right := col;
  real.Selection := rect;

  result := This;
end;

function DrawGrid_get_editor_mode(This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_bool(real.EditorMode);
end;

function DrawGrid_set_editor_mode(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
begin
  real := ap_data_get_struct(This);
  real.EditorMode := dl_Boolean(v);
  result := v;
end;

function DrawGrid_get_col(This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Col);
end;

function DrawGrid_set_col(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(v);
  if (n < 0) or (n >= real.ColCount) then
    ap_raise(ap_eArgError, sOut_of_range);
  real.Col := n;
  result := v;
end;

function DrawGrid_get_row(This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.Row);
end;

function DrawGrid_set_row(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(v);
  if (n < 0) or (n >= real.RowCount) then
    ap_raise(ap_eArgError, sOut_of_range);
  real.Row := n;
  result := v;
end;

function DrawGrid_get_top_row(This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.TopRow);
end;

function DrawGrid_set_top_row(This, v: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  n: Integer;
begin
  real := ap_data_get_struct(This);
  n := FIX2INT(v);
  if (n < 0) or (n >= real.RowCount) then
    ap_raise(ap_eArgError, sOut_of_range);
  real.TopRow := n;
  result := v;
end;

function DrawGrid_set_row_heights(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  args: array of Tvalue;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  real.RowHeights[dl_Integer(args[0])] := dl_Integer(args[1]);
  result := args[1];
end;

function DrawGrid_get_row_heights(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TDrawGrid;
  args: array of Tvalue;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  result := ap_Integer(real.RowHeights[dl_Integer(args[0])]);
end;

//// StringGrid ////

procedure StringGrid_setup(obj: Tvalue; real: TStringGrid);
begin
  rb_iv_set(obj, '@brush', ap_iBrush(real.Brush, obj));
  rb_iv_set(obj, '@canvas', ap_iCanvas(real.Canvas, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function StringGrid_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function StringGrid_alloc(This: Tvalue; real: TStringGrid): Tvalue;
begin
  result := ChildAlloc(This, real);
  StringGrid_setup(result, real);
end;

function ap_StringGrid(real: TStringGrid; owner: Tvalue): Tvalue;
begin
  result := StringGrid_alloc(cStringGrid, real);
  ap_owner(result, owner);
end;

function ap_StringGrid_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_StringGrid(TStringGrid(AControl), owner)
end;

function StringGrid_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
begin
  real := TStringGrid.Create(nil);
  result := CompoAlloc(This, real);
  StringGrid_setup(result, real);
end;

function StringGrid_get_cells(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: Rubies.Pvalue;
  Col, Row: Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  args := Rubies.Pvalue(argv);
  real := ap_data_get_struct(This);
  Col := FIX2INT(args^);
  dec(argc);
  inc(args);
  Row := FIX2INT(args^);
  dec(argc);
  inc(args);
  result := rb_str_new2(PChar(real.Cells[Col, Row]));
end;

function StringGrid_set_cells(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: Rubies.Pvalue;
  Col, Row: Integer;
  v: Tvalue;
begin
  if argc < 3 then ap_raise(ap_eArgError, sToo_few_args);
  args := Rubies.Pvalue(argv);
  real := ap_data_get_struct(This);
  Col := FIX2INT(args^);
  dec(argc);
  inc(args);
  Row := FIX2INT(args^);
  dec(argc);
  inc(args);
  v := args^;
  real.Cells[Col, Row] := dl_String(v);
  result := v;
end;

function StringGrid_get_col_widths(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: array of Tvalue;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ColWidths[FIX2INT(args[0])]); // [ap-dev:1424]
end;

function StringGrid_set_col_widths(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: array of Tvalue;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  real.ColWidths[FIX2INT(args[0])] := dl_Integer(args[1]);
  result := args[1];
end;

// [ap-dev:1402] Morita Keisuke (morita@asobitari.nu)
function StringGrid_get_cols(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: Rubies.Pvalue;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  args := Rubies.Pvalue(argv);
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.Cols[FIX2INT(args^)], This);
end;

function StringGrid_set_cols(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: Rubies.Pvalue;
  Col: Integer;
  v: Tvalue;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  args := Rubies.Pvalue(argv);
  real := ap_data_get_struct(This);
  Col := FIX2INT(args^);
  dec(argc);
  inc(args);
  v := args^;
  real.Cols[Col] := dl_Strings(v);
  result := v;
end;

function StringGrid_get_rows(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: Rubies.Pvalue;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  args := Rubies.Pvalue(argv);
  real := ap_data_get_struct(This);
  result := ap_iStrings(real.Rows[FIX2INT(args^)], This);
end;

function StringGrid_set_rows(argc: Integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  real: TStringGrid;
  args: Rubies.Pvalue;
  Row: Integer;
  v: Tvalue;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  args := Rubies.Pvalue(argv);
  real := ap_data_get_struct(This);
  Row := FIX2INT(args^);
  dec(argc);
  inc(args);
  v := args^;
  real.Rows[Row] := dl_Strings(v);
  result := v;
end;

(**** str_method made by ap_src_maker ****)

function CustomGrid_change_grid_orientation(This, RightToLeftOrientation : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_RightToLeftOrientation : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_RightToLeftOrientation := dl_Boolean(RightToLeftOrientation);
  real.ChangeGridOrientation( dlv_RightToLeftOrientation );
  result := This;
end;

function CustomGrid_box_rect(This, ALeft, ATop, ARight, ABottom : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ALeft : Longint;
  dlv_ATop : Longint;
  dlv_ARight : Longint;
  dlv_ABottom : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_ALeft := dl_Integer(ALeft);
  dlv_ATop := dl_Integer(ATop);
  dlv_ARight := dl_Integer(ARight);
  dlv_ABottom := dl_Integer(ABottom);
  result := ap_iRect(real.BoxRect( dlv_ALeft, dlv_ATop, dlv_ARight, dlv_ABottom ),This);
end;

function CustomGrid_do_exit(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.DoExit;
  result := This;
end;

function CustomGrid_can_edit_show(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.CanEditShow);
end;

function CustomGrid_focus_cell(This, ACol, ARow, MoveAnchor : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ACol : Longint;
  dlv_ARow : Longint;
  dlv_MoveAnchor : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  dlv_ARow := dl_Integer(ARow);
  dlv_MoveAnchor := dl_Boolean(MoveAnchor);
  real.FocusCell( dlv_ACol, dlv_ARow, dlv_MoveAnchor );
  result := This;
end;

function CustomGrid_get_grid_width(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.GetGridWidth);
end;

function CustomGrid_get_grid_height(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.GetGridHeight);
end;

function CustomGrid_hide_edit(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.HideEdit;
  result := This;
end;

function CustomGrid_hide_editor(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.HideEditor;
  result := This;
end;

function CustomGrid_show_editor(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.ShowEditor;
  result := This;
end;

function CustomGrid_show_editor_char(This, Ch : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_Ch : Char;
begin
  real := ap_data_get_struct(This);
  dlv_Ch := char(dl_Integer(Ch));
  real.ShowEditorChar( dlv_Ch );
  result := This;
end;

function CustomGrid_invalidate_editor(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.InvalidateEditor;
  result := This;
end;

function CustomGrid_invalidate_grid(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.InvalidateGrid;
  result := This;
end;

function CustomGrid_move_column(This, FromIndex, ToIndex : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_FromIndex : Longint;
  dlv_ToIndex : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_FromIndex := dl_Integer(FromIndex);
  dlv_ToIndex := dl_Integer(ToIndex);
  real.MoveColumn( dlv_FromIndex, dlv_ToIndex );
  result := This;
end;

function CustomGrid_move_row(This, FromIndex, ToIndex : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_FromIndex : Longint;
  dlv_ToIndex : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_FromIndex := dl_Integer(FromIndex);
  dlv_ToIndex := dl_Integer(ToIndex);
  real.MoveRow( dlv_FromIndex, dlv_ToIndex );
  result := This;
end;

function CustomGrid_move_col_row(This, ACol, ARow, MoveAnchor, Show : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ACol : Longint;
  dlv_ARow : Longint;
  dlv_MoveAnchor : Boolean;
  dlv_Show : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  dlv_ARow := dl_Integer(ARow);
  dlv_MoveAnchor := dl_Boolean(MoveAnchor);
  dlv_Show := dl_Boolean(Show);
  real.MoveColRow( dlv_ACol, dlv_ARow, dlv_MoveAnchor, dlv_Show );
  result := This;
end;

function CustomGrid_select_cell(This, ACol, ARow : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ACol : Longint;
  dlv_ARow : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  dlv_ARow := dl_Integer(ARow);
  result := ap_Bool(real.SelectCell( dlv_ACol, dlv_ARow ));
end;

function CustomGrid_sizing(This, X, Y : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_X : Integer;
  dlv_Y : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_X := dl_Integer(X);
  dlv_Y := dl_Integer(Y);
  result := ap_Bool(real.Sizing( dlv_X, dlv_Y ));
end;

function CustomGrid_scroll_data(This, DX, DY : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_DX : Integer;
  dlv_DY : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_DX := dl_Integer(DX);
  dlv_DY := dl_Integer(DY);
  real.ScrollData( dlv_DX, dlv_DY );
  result := This;
end;

function CustomGrid_invalidate_cell(This, ACol, ARow : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ACol : Longint;
  dlv_ARow : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  dlv_ARow := dl_Integer(ARow);
  real.InvalidateCell( dlv_ACol, dlv_ARow );
  result := This;
end;

function CustomGrid_invalidate_col(This, ACol : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ACol : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  real.InvalidateCol( dlv_ACol );
  result := This;
end;

function CustomGrid_invalidate_row(This, ARow : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ARow : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_ARow := dl_Integer(ARow);
  real.InvalidateRow( dlv_ARow );
  result := This;
end;

function CustomGrid_delete_column(This, ACol : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ACol : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(ACol);
  real.DeleteColumn( dlv_ACol );
  result := This;
end;

function CustomGrid_delete_row(This, ARow : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_ARow : Longint;
begin
  real := ap_data_get_struct(This);
  dlv_ARow := dl_Integer(ARow);
  real.DeleteRow( dlv_ARow );
  result := This;
end;

function CustomGrid_update_designer(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.UpdateDesigner;
  result := This;
end;

function CustomGrid_get_border_style(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.BorderStyle));
end;

function CustomGrid_get_col(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.Col);
end;

function CustomGrid_set_col(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.Col := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_col_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.ColCount);
end;

function CustomGrid_set_col_count(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.ColCount := dl_Integer(v);
  result := v;
end;

function CustomGrid_set_col_widths(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_Index : Longint;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.ColWidths[dlv_Index] := dl_Integer(argv[1]);
  result := argv[1];
end;

function CustomGrid_get_col_widths(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_Index : Longint;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Integer(real.ColWidths[dlv_Index]);
end;

function CustomGrid_get_default_col_width(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.DefaultColWidth);
end;

function CustomGrid_set_default_col_width(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.DefaultColWidth := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_default_drawing(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.DefaultDrawing);
end;

function CustomGrid_set_default_drawing(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.DefaultDrawing := dl_Boolean(v);
  result := v;
end;

function CustomGrid_get_default_row_height(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.DefaultRowHeight);
end;

function CustomGrid_set_default_row_height(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.DefaultRowHeight := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_editor_mode(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.EditorMode);
end;

function CustomGrid_set_editor_mode(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.EditorMode := dl_Boolean(v);
  result := v;
end;

function CustomGrid_get_fixed_color(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.FixedColor));
end;

function CustomGrid_get_fixed_cols(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.FixedCols);
end;

function CustomGrid_set_fixed_cols(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.FixedCols := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_fixed_rows(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.FixedRows);
end;

function CustomGrid_set_fixed_rows(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.FixedRows := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_grid_line_width(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.GridLineWidth);
end;

function CustomGrid_set_grid_line_width(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.GridLineWidth := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_left_col(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.LeftCol);
end;

function CustomGrid_set_left_col(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.LeftCol := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_row(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.Row);
end;

function CustomGrid_set_row(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.Row := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_row_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.RowCount);
end;

function CustomGrid_set_row_count(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.RowCount := dl_Integer(v);
  result := v;
end;

function CustomGrid_set_row_heights(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_Index : Longint;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.RowHeights[dlv_Index] := dl_Integer(argv[1]);
  result := argv[1];
end;

function CustomGrid_get_row_heights(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_Index : Longint;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Integer(real.RowHeights[dlv_Index]);
end;

function CustomGrid_get_scroll_bars(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(ord(real.ScrollBars));
end;

function CustomGrid_set_tab_stops(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_Index : Longint;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.TabStops[dlv_Index] := dl_Boolean(argv[1]);
  result := argv[1];
end;

function CustomGrid_get_tab_stops(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
  dlv_Index : Longint;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_Bool(real.TabStops[dlv_Index]);
end;

function CustomGrid_get_top_row(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.TopRow);
end;

function CustomGrid_set_top_row(This, v: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  real.TopRow := dl_Integer(v);
  result := v;
end;

function CustomGrid_get_visible_col_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.VisibleColCount);
end;

function CustomGrid_get_visible_row_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_CustomGrid;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.VisibleRowCount);
end;
(**** made by ap_src_maker ****)

procedure Init_Grid;
begin
  OutputConstSetType(mPhi, TypeInfo(TGridDrawStateKind));
  OutputConstSetType(mPhi, TypeInfo(TGridOption));

  cCustomGrid := OutputPersistentClass(mPhi, TCustomGrid, cWinControl, nil);
  rb_define_method(cCustomGrid, 'cell_rect', @CustomGrid_cell_rect, 2);
  rb_define_method(cCustomGrid, 'mouse_coord', @CustomGrid_mouse_coord, 2);
  rb_define_attr(cCustomGrid, 'canvas', 1, 0);

  cDrawGrid := OutputPersistentClass(mPhi, TDrawGrid, cCustomGrid, ap_DrawGrid_v);
  rb_define_method(cDrawGrid, 'event_handle', @DrawGrid_event_handle, 1);
  rb_define_alloc_func(cDrawGrid, @DrawGrid_allocate);
  rb_define_method(cDrawGrid, 'mouse_to_cell', @DrawGrid_mouse_to_cell, 2);
  rb_define_method(cDrawGrid, 'select_cell', @DrawGrid_select_cell, 2);
  DefineAttrGet(cDrawGrid, 'editor_mode', DrawGrid_get_editor_mode);
  DefineAttrSet(cDrawGrid, 'editor_mode', DrawGrid_set_editor_mode);
  DefineAttrGet(cDrawGrid, 'col', DrawGrid_get_col);
  DefineAttrSet(cDrawGrid, 'col', DrawGrid_set_col);
  DefineAttrGet(cDrawGrid, 'row', DrawGrid_get_row);
  DefineAttrSet(cDrawGrid, 'row', DrawGrid_set_row);
  DefineAttrGet(cDrawGrid, 'top_row', DrawGrid_get_top_row);
  DefineAttrSet(cDrawGrid, 'top_row', DrawGrid_set_top_row);
  // [ap-dev:1474]
  DefineIndexer(cDrawGrid, 'row_heights', @DrawGrid_get_row_heights, @DrawGrid_set_row_heights);

  cStringGrid := OutputPersistentClass(mPhi, TStringGrid, cDrawGrid, ap_StringGrid_v);
  rb_define_method(cStringGrid, 'event_handle', @StringGrid_event_handle, 1);
  rb_define_alloc_func(cStringGrid, @StringGrid_allocate);
  DefineIndexer(cStringGrid, 'cells', @StringGrid_get_cells, @StringGrid_set_cells);
  DefineIndexer(cStringGrid, 'col_widths', @StringGrid_get_col_widths, @StringGrid_set_col_widths);
  // [ap-dev:1402] Morita Keisuke (morita@asobitari.nu)
  DefineIndexer(cStringGrid, 'cols', @StringGrid_get_cols, @StringGrid_set_cols);
  DefineIndexer(cStringGrid, 'rows', @StringGrid_get_rows, @StringGrid_set_rows);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cCustomGrid, 'change_grid_orientation', @CustomGrid_change_grid_orientation, 1);
  rb_define_method(cCustomGrid, 'box_rect', @CustomGrid_box_rect, 4);
  rb_define_method(cCustomGrid, 'do_exit', @CustomGrid_do_exit, 0);
  rb_define_method(cCustomGrid, 'focus_cell', @CustomGrid_focus_cell, 3);
  rb_define_method(cCustomGrid, 'hide_edit', @CustomGrid_hide_edit, 0);
  rb_define_method(cCustomGrid, 'hide_editor', @CustomGrid_hide_editor, 0);
  rb_define_method(cCustomGrid, 'show_editor', @CustomGrid_show_editor, 0);
  rb_define_method(cCustomGrid, 'show_editor_char', @CustomGrid_show_editor_char, 1);
  rb_define_method(cCustomGrid, 'invalidate_editor', @CustomGrid_invalidate_editor, 0);
  rb_define_method(cCustomGrid, 'invalidate_grid', @CustomGrid_invalidate_grid, 0);
  rb_define_method(cCustomGrid, 'move_column', @CustomGrid_move_column, 2);
  rb_define_method(cCustomGrid, 'move_row', @CustomGrid_move_row, 2);
  rb_define_method(cCustomGrid, 'move_col_row', @CustomGrid_move_col_row, 4);
  rb_define_method(cCustomGrid, 'select_cell', @CustomGrid_select_cell, 2);
  rb_define_method(cCustomGrid, 'sizing', @CustomGrid_sizing, 2);
  rb_define_method(cCustomGrid, 'scroll_data', @CustomGrid_scroll_data, 2);
  rb_define_method(cCustomGrid, 'invalidate_cell', @CustomGrid_invalidate_cell, 2);
  rb_define_method(cCustomGrid, 'invalidate_col', @CustomGrid_invalidate_col, 1);
  rb_define_method(cCustomGrid, 'invalidate_row', @CustomGrid_invalidate_row, 1);
  rb_define_method(cCustomGrid, 'delete_column', @CustomGrid_delete_column, 1);
  rb_define_method(cCustomGrid, 'delete_row', @CustomGrid_delete_row, 1);
  rb_define_method(cCustomGrid, 'update_designer', @CustomGrid_update_designer, 0);
  DefineAttrGet(cCustomGrid, 'border_style', CustomGrid_get_border_style);
  DefineAttrGet(cCustomGrid, 'col', CustomGrid_get_col);
  DefineAttrSet(cCustomGrid, 'col', CustomGrid_set_col);
  DefineAttrGet(cCustomGrid, 'col_count', CustomGrid_get_col_count);
  DefineAttrSet(cCustomGrid, 'col_count', CustomGrid_set_col_count);
  DefineIndexer(cCustomGrid, 'col_widths', @CustomGrid_get_col_widths, @CustomGrid_set_col_widths);
  DefineAttrGet(cCustomGrid, 'default_col_width', CustomGrid_get_default_col_width);
  DefineAttrSet(cCustomGrid, 'default_col_width', CustomGrid_set_default_col_width);
  DefineAttrGet(cCustomGrid, 'default_drawing', CustomGrid_get_default_drawing);
  rb_define_alias(cCustomGrid , 'default_drawing?', 'default_drawing');
  DefineAttrSet(cCustomGrid, 'default_drawing', CustomGrid_set_default_drawing);
  DefineAttrGet(cCustomGrid, 'default_row_height', CustomGrid_get_default_row_height);
  DefineAttrSet(cCustomGrid, 'default_row_height', CustomGrid_set_default_row_height);
  DefineAttrGet(cCustomGrid, 'editor_mode', CustomGrid_get_editor_mode);
  rb_define_alias(cCustomGrid , 'editor_mode?', 'editor_mode');
  DefineAttrSet(cCustomGrid, 'editor_mode', CustomGrid_set_editor_mode);
  DefineAttrGet(cCustomGrid, 'fixed_color', CustomGrid_get_fixed_color);
  DefineAttrGet(cCustomGrid, 'fixed_cols', CustomGrid_get_fixed_cols);
  DefineAttrSet(cCustomGrid, 'fixed_cols', CustomGrid_set_fixed_cols);
  DefineAttrGet(cCustomGrid, 'fixed_rows', CustomGrid_get_fixed_rows);
  DefineAttrSet(cCustomGrid, 'fixed_rows', CustomGrid_set_fixed_rows);
  DefineAttrGet(cCustomGrid, 'grid_height', CustomGrid_get_grid_height);
  DefineAttrGet(cCustomGrid, 'grid_line_width', CustomGrid_get_grid_line_width);
  DefineAttrSet(cCustomGrid, 'grid_line_width', CustomGrid_set_grid_line_width);
  DefineAttrGet(cCustomGrid, 'grid_width', CustomGrid_get_grid_width);
  DefineAttrGet(cCustomGrid, 'left_col', CustomGrid_get_left_col);
  DefineAttrSet(cCustomGrid, 'left_col', CustomGrid_set_left_col);
  DefineAttrGet(cCustomGrid, 'row', CustomGrid_get_row);
  DefineAttrSet(cCustomGrid, 'row', CustomGrid_set_row);
  DefineAttrGet(cCustomGrid, 'row_count', CustomGrid_get_row_count);
  DefineAttrSet(cCustomGrid, 'row_count', CustomGrid_set_row_count);
  DefineIndexer(cCustomGrid, 'row_heights', @CustomGrid_get_row_heights, @CustomGrid_set_row_heights);
  DefineAttrGet(cCustomGrid, 'scroll_bars', CustomGrid_get_scroll_bars);
  DefineIndexer(cCustomGrid, 'tab_stops', @CustomGrid_get_tab_stops, @CustomGrid_set_tab_stops);
  DefineAttrGet(cCustomGrid, 'top_row', CustomGrid_get_top_row);
  DefineAttrSet(cCustomGrid, 'top_row', CustomGrid_set_top_row);
  DefineAttrGet(cCustomGrid, 'visible_col_count', CustomGrid_get_visible_col_count);
  DefineAttrGet(cCustomGrid, 'visible_row_count', CustomGrid_get_visible_row_count);
(**** made by ap_src_maker ****)

end;

end.
