unit uPageScroller;

interface

uses
  ComCtrls,
  Rubies;

var
  cPageScroller: Tvalue;

function ap_cPageScroller: Tvalue;
function ap_iPageScroller(real: TPageScroller; owner: Tvalue): Tvalue;
procedure Init_PageScroller;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uCanvas, uFont,
  uPersistent, uComponent, uControl;

function ap_cPageScroller: Tvalue;
begin
  result := cPageScroller;
end;

procedure PageScroller_setup(obj: Tvalue; real: TPageScroller);
begin
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function PageScroller_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function PageScroller_alloc(This: Tvalue; real: TPageScroller): Tvalue;
begin
  result := ChildAlloc(This, real);
  PageScroller_setup(result, real);
end;

function ap_iPageScroller(real: TPageScroller; owner: Tvalue): Tvalue;
begin
  result := PageScroller_alloc(cPageScroller, real);
  ap_owner(result, owner);
end;

function ap_iPageScroller_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iPageScroller(TPageScroller(AControl), owner);
end;

function PageScroller_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TPageScroller;
begin
  real := TPageScroller.Create(nil);
  result := CompoAlloc(This, real);
  PageScroller_setup(result, real);
end;

procedure Init_PageScroller;
begin
  OutputConstSetType(mPhi, TypeInfo(TPageScrollerOrientation));

  cPageScroller := OutputPersistentClass(mPhi, TPageScroller, cWinControl, ap_iPageScroller_v);
  rb_define_method(cPageScroller, 'event_handle', @PageScroller_event_handle, 1);
  rb_define_alloc_func(cPageScroller, @PageScroller_allocate);
end;

end.

