unit uRadioButton;

interface

uses
{$IFDEF VCL}
  StdCtrls,
{$ELSE}
  QStdCtrls,
{$ENDIF}
  Rubies;

var
  cRadioButton: Tvalue;

function ap_cRadioButton: Tvalue;
function ap_iRadioButton(real: TRadioButton; owner: Tvalue): Tvalue;
procedure Init_RadioButton;

implementation

uses
  Classes,
  uConv, uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl, uButton;

function ap_cRadioButton: Tvalue;
begin
  result := cRadioButton;
end;

procedure RadioButton_setup(obj: Tvalue; real: TRadioButton);
begin
//    AssignPropMethod(real, [Handle]);
end;

function RadioButton_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function RadioButton_alloc(This: Tvalue; real: TRadioButton): Tvalue;
begin
  result := ChildAlloc(This, real);
  RadioButton_setup(result, real);
end;

function ap_iRadioButton(real: TRadioButton; owner: Tvalue): Tvalue;
begin
  result := RadioButton_alloc(cRadioButton, real);
  ap_owner(result, owner);
end;

function ap_iRadioButton_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iRadioButton(TRadioButton(AControl), owner);
end;

function RadioButton_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TRadioButton;
begin
  real := TRadioButton.Create(nil);
  result := CompoAlloc(This, real);
  RadioButton_setup(result, real);
end;

function RadioButton_set_caption(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRadioButton;
begin
  real := ap_data_get_struct(This);
  real.caption := dl_String(v);
  result := v;
end;

procedure Init_RadioButton;
begin
  cRadioButton := OutputPersistentClass(mPhi, TRadioButton, cButton, ap_iRadioButton_v);
  rb_define_method(cRadioButton, 'event_handle', @RadioButton_event_handle, 1);
  rb_define_alloc_func(cRadioButton, @RadioButton_allocate);
  DefineAttrSet(cRadioButton, 'caption', RadioButton_set_caption);
end;

end.
