unit uRichEdit;

interface

uses Rubies, ComCtrls;

var
  cRichEdit: Tvalue;

function ap_cRichEdit: Tvalue;
function ap_iRichEdit(real: TRichEdit; owner: Tvalue): Tvalue;
procedure Init_RichEdit;

implementation

uses
  uSearchTypes,
  uRect, // ap_iRect, dl_Rect;
  uConv,
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints, uStrings, uFont, uTextAttributes, uEdit,
  uPersistent, uComponent, uControl;

function ap_cRichEdit: Tvalue;
begin
  result := cRichEdit;
end;

procedure RichEdit_setup(obj: Tvalue; real: TRichEdit);
begin
  rb_iv_set(obj, '@lines', ap_iStrings(real.Lines, obj));
//  rb_iv_set(obj, '@font', ap_iFont(real.Font, obj));
//    AssignPropMethod(real, [Handle]);
end;

function RichEdit_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function RichEdit_alloc(This: Tvalue; real: TRichEdit): Tvalue;
begin
  result := ChildAlloc(This, real);
  RichEdit_setup(result, real);
end;

function ap_iRichEdit(real: TRichEdit; owner: Tvalue): Tvalue;
begin
  result := RichEdit_alloc(cRichEdit, real);
  ap_owner(result, owner);
end;

function ap_iRichEdit_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iRichEdit(TRichEdit(AControl), owner);
end;

function RichEdit_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := TRichEdit.Create(nil);
  result := CompoAlloc(This, real);
  RichEdit_setup(result, real);
end;

function RichEdit_clear(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.Clear;
  result := This;
end;

function RichEdit_get_text(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  result := rb_str_new2(PChar(real.Text));
end;

function RichEdit_set_text(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.Text := dl_String(v);
  result := v;
end;

function RichEdit_get_sel_attributes(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
  TextAttributes: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  TextAttributes := real.SelAttributes;
  result := ap_iTextAttributes(TextAttributes, This);
end;

function RichEdit_set_sel_attributes(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
  TextAttributes: TTextAttributes;
begin
  real := ap_data_get_struct(This);
  ap_data_get_object(v, TTextAttributes, TextAttributes);
  real.SelAttributes := TextAttributes;
  result := v;
end;

function RichEdit_print(This, caption: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.Print(dl_String(caption));
  result := Qnil;
end;

function RichEdit_find_text(This, SearchStr, StartPos, Length, Options : Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
  dl_SearchStr : string;
  dl_StartPos : Integer;
  dl_Length : Integer;
  dl_Options : TSearchTypes;
begin
  real := ap_data_get_struct(This);
  dl_SearchStr := dl_String(SearchStr);
  dl_StartPos := dl_Integer(StartPos);
  dl_Length := dl_Integer(Length);
  dl_Options := dl_SearchTypes(Options);
  result := ap_Integer(real.FindText( dl_SearchStr, dl_StartPos, dl_Length, dl_Options ));
end;

function RichEdit_get_def_attributes(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_iTextAttributes(real.DefAttributes,This);  
end;

function RichEdit_set_def_attributes(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.DefAttributes := ap_data_get_struct(v);
  result := v;
end;

function RichEdit_get_page_rect(This: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  result := ap_iRect(real.PageRect,This);  
end;

function RichEdit_set_page_rect(This, v: Tvalue): Tvalue; cdecl;
var
  real: TRichEdit;
begin
  real := ap_data_get_struct(This);
  real.PageRect := dl_Rect(v);
  result := v;
end;

procedure Init_RichEdit;
begin
  DefineConstSetType(ap_mPhi, TypeInfo(TSearchType));

  cRichEdit := OutputPersistentClass(mPhi, TRichEdit, cEdit, ap_iRichEdit_v);
  rb_define_method(cRichEdit, 'event_handle', @RichEdit_event_handle, 1);
  rb_define_alloc_func(cRichEdit, @RichEdit_allocate);
  rb_define_method(cRichEdit, 'clear', @RichEdit_clear, 0);
  DefineAttrGet(cRichEdit, 'text', RichEdit_get_text);
  DefineAttrSet(cRichEdit, 'text', RichEdit_set_text);
  DefineAttrGet(cRichEdit, 'sel_attributes', RichEdit_get_sel_attributes);
  DefineAttrSet(cRichEdit, 'sel_attributes', RichEdit_set_sel_attributes);
  rb_define_method(cRichEdit, 'print', @RichEdit_print, 1);
  DefineAttrGet(cRichEdit, 'def_attributes', RichEdit_get_def_attributes);
  DefineAttrSet(cRichEdit, 'def_attributes', RichEdit_set_def_attributes);
  DefineAttrGet(cRichEdit, 'page_rect', RichEdit_get_page_rect);
  DefineAttrSet(cRichEdit, 'page_rect', RichEdit_set_page_rect);
  rb_define_method(cRichEdit, 'find_text', @RichEdit_find_text, 4);
end;

end.
