unit uTabControl;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Rubies;

var
  cTabControl: Tvalue;

function ap_cTabControl: Tvalue;
function ap_iTabControl(real: TTabControl; owner: Tvalue): Tvalue;
procedure Init_TabControl;

implementation

uses
  SysUtils, Classes,
  uStrings,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uPersistent, uComponent, uControl;

function ap_cTabControl: Tvalue;
begin
  result := cTabControl;
end;

procedure TabControl_setup(obj: Tvalue; real: TTabControl);
begin
  rb_iv_set(obj, '@tabs', ap_iStrings(real.Tabs, obj));
//
end;

function TabControl_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function TabControl_alloc(This: Tvalue; real: TTabControl): Tvalue;
begin
  result := ChildAlloc(This, real);
  TabControl_setup(result, real);
end;

function ap_iTabControl(real: TTabControl; owner: Tvalue): Tvalue;
begin
  result := TabControl_alloc(cTabControl, real);
  ap_owner(result, owner);
end;

function ap_iTabControl_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iTabControl(TTabControl(AControl), owner);
end;

function TabControl_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TTabControl;
begin
  real := TTabControl.Create(nil);
  result := CompoAlloc(This, real);
  TabControl_setup(result, real);
end;

function TabControl_get_row_count(This: Tvalue): Tvalue; cdecl;
var
  real: TTabControl;
begin
  real := ap_data_get_struct(This);
  result := INT2FIX(real.RowCount);
end;

function TabControl_scroll_tabs(argc: integer; argv: Pointer; This: Tvalue): Tvalue; cdecl;
var
  args: array of Tvalue;
  real: TTabControl;
begin
  if argc > 1 then ap_raise(ap_eArgError, sWrong_num_of_args);
  SetLength(args, argc);
  args := argv;
  real := ap_data_get_struct(This);
  real.ScrollTabs(INT2FIX(args[0]));
  result := Qnil;
end;

procedure Init_TabControl;
begin
  cTabControl := OutputPersistentClass(mPhi, TTabControl, cWinControl, ap_iTabControl_v);
  rb_define_method(cTabControl, 'event_handle', @TabControl_event_handle, 1);
  rb_define_alloc_func(cTabControl, @TabControl_allocate);
  DefineAttrGet(cTabControl, 'row_count', TabControl_get_row_count);
  DefineMethod(cTabControl, 'scroll_tabs', TabControl_scroll_tabs);
end;

end.
