unit uValueListEditor;

interface

uses
{$IFDEF VCL}
  ComCtrls,
{$ELSE}
  QComCtrls,
{$ENDIF}
  Valedit,
  Rubies;

var
  cValueListEditor: Tvalue;

function ap_cValueListEditor: Tvalue;
function ap_iValueListEditor(real: TValueListEditor; owner: Tvalue): Tvalue;
procedure Init_ValueListEditor;

implementation

uses
  SysUtils, Classes,
  uDefUtils, uIntern, uHandle, uAlloc, uProp, uPhi,
  uSizeConstraints,
  uConv, uGrid,
  uIndexer, uStrings,
  uPersistent, uComponent, uControl;

function ap_cValueListEditor: Tvalue;
begin
  result := cValueListEditor;
end;

procedure ValueListEditor_setup(obj: Tvalue; real: TValueListEditor);
begin
  rb_iv_set(obj, '@strings', ap_iStrings(real.Strings, obj));
//    AssignPropMethod(real, [Handle]);
end;

function ValueListEditor_event_handle(This, name: Tvalue): Tvalue; cdecl;
begin
  EventHandle(This, name, [Handle]);
  result := Qnil;
end;

function ValueListEditor_alloc(This: Tvalue; real: TValueListEditor): Tvalue;
begin
  result := ChildAlloc(This, real);
  ValueListEditor_setup(result, real);
end;

function ap_iValueListEditor(real: TValueListEditor; owner: Tvalue): Tvalue;
begin
  result := ValueListEditor_alloc(cValueListEditor, real);
  ap_owner(result, owner);
end;

function ap_iValueListEditor_v(var AControl; owner: Tvalue): Tvalue;
begin
  result := ap_iValueListEditor(TValueListEditor(AControl), owner);
end;

function ValueListEditor_allocate(This: Tvalue): Tvalue; cdecl;
var
  real: TValueListEditor;
begin
  real := TValueListEditor.Create(nil);
  result := CompoAlloc(This, real);
  ValueListEditor_setup(result, real);
end;

(**** str_my_class made by ap_src_maker ****)
type
TPhi_ValueListEditor = class(TValueListEditor)
end;
(**** made by ap_src_maker ****)
(**** str_method made by ap_src_maker ****)

function ValueListEditor_delete_row(This, ARow : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_ARow : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_ARow := dl_Integer(ARow);
  real.DeleteRow( dlv_ARow );
  result := This;
end;

function ValueListEditor_find_row(This, KeyName, Row : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_KeyName : string;
  dlv_Row : Integer;
begin
  real := ap_data_get_struct(This);
  dlv_KeyName := dl_String(KeyName);
  dlv_Row := dl_Integer(Row);
  result := ap_Bool(real.FindRow( dlv_KeyName, dlv_Row ));
end;

function ValueListEditor_insert_row(This, KeyName, Value, Append : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_KeyName : string;
  dlv_Value : string;
  dlv_Append : Boolean;
begin
  real := ap_data_get_struct(This);
  dlv_KeyName := dl_String(KeyName);
  dlv_Value := dl_String(Value);
  dlv_Append := dl_Boolean(Append);
  result := ap_Integer(real.InsertRow( dlv_KeyName, dlv_Value, dlv_Append ));
end;

function ValueListEditor_restore_current_row(This : Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Bool(real.RestoreCurrentRow);
end;

function ValueListEditor_set_cells(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_ACol : Integer;
  dlv_ARow : Integer;
begin
  if argc < 3 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(argv[0]);
  dlv_ARow := dl_Integer(argv[1]);
  real.Cells[dlv_ACol, dlv_ARow] := dl_String(argv[2]);
  result := argv[2];
end;

function ValueListEditor_get_cells(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_ACol : Integer;
  dlv_ARow : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_ACol := dl_Integer(argv[0]);
  dlv_ARow := dl_Integer(argv[1]);
  result := ap_String(real.Cells[dlv_ACol, dlv_ARow]);
end;

function ValueListEditor_set_keys(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_Index : Integer;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  real.Keys[dlv_Index] := dl_String(argv[1]);
  result := argv[1];
end;

function ValueListEditor_get_keys(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_Index : Integer;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Index := dl_Integer(argv[0]);
  result := ap_String(real.Keys[dlv_Index]);
end;

function ValueListEditor_get_row_count(This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
begin
  real := ap_data_get_struct(This);
  result := ap_Integer(real.RowCount);  
end;

function ValueListEditor_set_values(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_Key : string;
begin
  if argc < 2 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Key := dl_String(argv[0]);
  real.Values[dlv_Key] := dl_String(argv[1]);
  result := argv[1];
end;

function ValueListEditor_get_values(argc: integer; argv: Tvalue_array; This: Tvalue): Tvalue; cdecl;
var
  real: TPhi_ValueListEditor;
  dlv_Key : string;
begin
  if argc < 1 then ap_raise(ap_eArgError, sToo_few_args);
  real := ap_data_get_struct(This);
  dlv_Key := dl_String(argv[0]);
  result := ap_String(real.Values[dlv_Key]);
end;
(**** made by ap_src_maker ****)

procedure Init_ValueListEditor;
begin
  cValueListEditor := OutputPersistentClass(mPhi, TValueListEditor, cCustomGrid, ap_iValueListEditor_v);
  rb_define_method(cValueListEditor, 'event_handle', @ValueListEditor_event_handle, 1);
  rb_define_alloc_func(cValueListEditor, @ValueListEditor_allocate);

(**** str_init made by ap_src_maker ****)
  rb_define_method(cValueListEditor, 'delete_row', @ValueListEditor_delete_row, 1);
  rb_define_method(cValueListEditor, 'find_row', @ValueListEditor_find_row, 2);
  rb_define_method(cValueListEditor, 'insert_row', @ValueListEditor_insert_row, 3);
  rb_define_method(cValueListEditor, 'restore_current_row', @ValueListEditor_restore_current_row, 0);
  DefineIndexer(cValueListEditor, 'cells', @ValueListEditor_get_cells, @ValueListEditor_set_cells);
  DefineIndexer(cValueListEditor, 'keys', @ValueListEditor_get_keys, @ValueListEditor_set_keys);
  DefineAttrGet(cValueListEditor, 'row_count', ValueListEditor_get_row_count);
  DefineIndexer(cValueListEditor, 'values', @ValueListEditor_get_values, @ValueListEditor_set_values);
//  DefineIndexer(cValueListEditor, 'item_props', @ValueListEditor_get_item_props, @ValueListEditor_set_item_props);
(**** made by ap_src_maker ****)

end;

end.

