package DBD::SalesForce::db;

# ----------------------------------------------------------------------
# $Id: db.pm,v 1.2 2004/03/04 23:21:22 dlc Exp $
# ----------------------------------------------------------------------
# The database handle (dbh)
# ----------------------------------------------------------------------

use strict;
use base qw(DBD::_::db);
use vars qw($VERSION $imp_data_size);

use DBI;
use Data::Dumper;
use SQL::Parser;

$VERSION = "0.01";
$imp_data_size = 0;

sub prepare {
    my ($dbh, $statement, @attr) = @_;
    my ($sth, @parsed, $salesforce, $search, $search_opts);

    my $parser = SQL::Parser->new;
    $parser->parse($statement)
        or die $parser->errstr;
    @parsed = [
        map { { FIELD    => $parser->structure->{'ORG_NAME'}->{$_},
                FUNCTION => $parser->structure->{'column_functions'}->{$_},
                ALIAS    => $parser->structure->{'column_aliases'}->{$_},
            } }          @{ $parser->structure->{'column_names'} }
    ];

    # Get the salesforce instance and %attr
    $salesforce = $dbh->FETCH('driver_salesforce');
    $search_opts = $dbh->FETCH('driver_salesforce_opts');

    # Create the search object
    $search = $salesforce->query(query => $statement, limit => '5');
    if ($search->valueof('//Body/Fault')) {
        die $search->valueof('//Body/Fault/detail/fault')->{'exceptionMessage'};
    }

    $sth = DBI::_new_sth($dbh, {
        'Statement' => $statement,
        'Columns' => @parsed,
        'SalesForceSearch' => $search,
    });

    # ?
    $sth->STORE('driver_params', [ ]);

    return $sth;
}

# ----------------------------------------------------------------------
# These next four methods are taken directly from DBI::DBD
# ----------------------------------------------------------------------
sub STORE {
    my ($dbh, $attr, $val) = @_;
    if ($attr eq 'AutoCommit') {
        return 1;
    }

    if ($attr =~ m/^driver_/) {
        $dbh->{$attr} = $val;
        return 1;
    }

    $dbh->SUPER::STORE($attr, $val);
}

sub FETCH {
    my ($dbh, $attr) = @_;

    if ($attr eq 'AutoCommit') {
        return 1
    }
    elsif ($attr =~ m/^driver_/) {
        return $dbh->{$attr};
    }

    $dbh->SUPER::FETCH($attr);
}

sub commit {
    my $dbh = shift;

    warn "Commit ineffective while AutoCommit is on"
        if $dbh->FETCH('Warn');

    1;
}

sub rollback {
    my $dbh = shift;

    warn "Rollback ineffective while AutoCommit is on"
        if $dbh->FETCH('Warn');

    0;
}

sub get_info {
    my($dbh, $info_type) = @_;
    require DBD::SalesForce::GetInfo;
    my $v = $DBD::SalesForce::GetInfo::info{int($info_type)};
    $v = $v->($dbh) if ref $v eq 'CODE';
    return $v;
}

1;

__END__
