package DBD::SalesForce::st;

# ----------------------------------------------------------------------
# $Id: st.pm,v 1.1 2004/02/04 17:27:45 dlc Exp $
# ----------------------------------------------------------------------
# DBD::SalesForce::st - Statement handle
# ----------------------------------------------------------------------

use strict;
use base qw(DBD::_::st);
use vars qw($VERSION $imp_data_size);

use DBI;

$VERSION = "0.01";
$imp_data_size = 0;

# ----------------------------------------------------------------------
# execute()
#
# I have no intention of supporting bind_params, BTW.
# ----------------------------------------------------------------------
sub execute {
    my $sth = shift;
    my (@data, @columns);
    my ($salesforce, $search, @results, $result);

    # The Salesforce::query instance
    $search = $sth->{'SalesForceSearch'};

    # The names of the columns in which we are interested
    @columns = @{ $sth->{'Columns'} };

    # This is where fetchrow_hashref etc get their names from
    $sth->{'NAME'} = [ map { $_->{'ALIAS'} } @columns ];

    # This executes the search
    @results = $search->valueof('//queryResponse/result/records');
    for my $result (@results) {
        my (@this, $column);
        for $column (@columns) {
            my $name = $column->{'FIELD'};
            if ($name eq 'ID') {
                push @this, $result->{'Id'};
            } elsif ($name eq 'FIRSTNAME') {
                push @this, $result->{'FirstName'};
            } elsif ($name eq 'LASTNAME') {
                push @this, $result->{'LastName'};
            } elsif ($name eq 'TYPE') {
                push @this, $result->{'type'};
            } else {
                push @this, 'unknown column: ' . $name;
            }
        }
        push @data, \@this;
    }

    $sth->{'driver_data'} = \@data;
    $sth->{'driver_rows'} =  @data;
    $sth->STORE('NUM_OF_FIELDS', scalar @columns);

    return scalar @data || 'E0E';
}

sub fetchrow_arrayref {
    my $sth = shift;
    my ($data, $row);

    $data = $sth->FETCH('driver_data');

    $row = shift @$data
        or return;

    return $sth->_set_fbav($row);
}
*fetch = *fetch = \&fetchrow_arrayref;

sub rows {
    my $sth = shift;
    return $sth->FETCH('driver_rows');
}

# Alas! This currently doesn't work.
sub totalrows {
    my $sth = shift;
    return $sth->estimateTotalResultsNumber();
}

# Returns available tables
sub table_info { return "SalesForce" }

# Implement metadata functions
{   no strict qw(refs);
    for my $sub (qw(documentFiltering searchComments searchQuery
                    estimateTotalResultsNumber estimateIsExact
                    startIndex endIndex searchTips searchTime)) {
        *{$sub} = sub {
            my $sth = shift;
            my $search = $sth->{'SalesForceSearch'};
            return $search->$sub() if defined $search;
            return;
        };
    }
}

1;

sub DESTROY { 1 }

__END__
