using System;
using System.Runtime.InteropServices;
using System.Windows.Forms;

namespace AppliStation.Util
{
	public sealed class NativeMethods
	{
		private NativeMethods()
		{
		}
		
		
		/// <summary>
		/// WindowsVistaAvOXo[Xe[^X(F)ݒ肷
		/// </summary>
		/// <param name="progBar">Ώۂ̃vOXo[</param>
		/// <param name="state">ԁB(1:Normal,2:Error,3:Paused)</param>
		public static void ProgressBar_SetState(ProgressBar progBar, uint state)
		{
			try {
				// status := (PBST_NORMAL | PBST_ERROR | PBST_PAUSED)
				// SendMessage(progressBar.Handle, PBM_SETSTATE, state, 0);
				SendMessage(progBar.Handle, 0x410, state, 0);
			} catch (Exception) {
			}
		}
		
		#region ^XNo[у^Cgo[̃tbV
		
		/// <summary>
		/// ^XNo[у^Cgo[{^̃tbV̐ݒtO
		/// </summary>
		public enum FlashFlag : uint {
			/// <summary>
			/// _ł̒~
			/// </summary>
			Stop = 0,
			/// <summary>
			/// ^Cgo[_
			/// </summary>
			Caption = 1,
			/// <summary>
			/// ^XNo[{^_
			/// </summary>
			Tray = 2,
			/// <summary>
			/// ^Cgo[ƃ^XNo[{^_
			/// </summary>
			All = 3,
			/// <summary>
			/// Stopݒ肳܂œ_ł
			/// </summary>
			Timer = 4,
			/// <summary>
			/// tHAOEh̏ԂɂȂ܂œ_
			/// </summary>
			TimerNoFG = 12,
		}
		
		[StructLayout(LayoutKind.Sequential)]
		struct FLASHWINFO
		{
		    public int cbSize;
		    public IntPtr hWnd;
		    public FlashFlag dwFlags;
		    public uint uCount;
		    public uint dwTimeout;
		}
		
		/// <summary>
		/// ^XNo[у^Cgo[{^_ł
		/// </summary>
		/// <param name="form">ΏۃtH[</param>
		/// <param name="flag">_Ńp[^tO</param>
		/// <param name="count">_ŉ</param>
		/// <param name="timeout">_ł̊Ԋu(~b)</param>
		/// <returns></returns>
		public static bool Form_FlashWindow(Form form, FlashFlag flag, uint count, uint timeout)
		{
			try {
				FLASHWINFO info = new FLASHWINFO();
				info.cbSize = Marshal.SizeOf(typeof(FLASHWINFO));
				info.hWnd = form.Handle;
				info.dwFlags = flag;
				info.uCount = count;
				info.dwTimeout = timeout;
				
				return FlashWindowEx(ref info) == 0;
			} catch (Exception) {
				return false;
			}
		}
		
		[DllImport("user32.dll")]
		static extern Int32 FlashWindowEx(ref FLASHWINFO pwfi);
		
		#endregion
		
		#region ColumnHeader̃\[g̎Opp
		
		[StructLayout(LayoutKind.Sequential, CharSet=CharSet.Auto)]
		internal struct HD_ITEM
		{
			public uint    mask;
			public int     cxy;
			[MarshalAs(UnmanagedType.LPTStr)]public string   pszText;
			public IntPtr   hbm;
			public int     cchTextMax;
			public int     fmt;
			[MarshalAs(UnmanagedType.LPTStr)]public string  lParam;
			public int     iImage;        // index of bitmap in ImageList
			public int     iOrder;
		}
		
		internal static IntPtr ListView_GetHeader(ListView listview)
		{
			// SendMessage(hWnd, LVM_GETHEADER, 0, NULL);
			return SendMessage(listview.Handle, 0x101E, 0, 0);
		}
		
		/// <summary>
		/// WinXPȍ~A\[g̖\
		/// </summary>
		/// <param name="listView">ΏۂListView</param>
		/// <param name="column">\̃wb_</param>
		/// <param name="order">\[g̏E~</param>
		public static void ColumnHeader_SetSortState(ListView listView, int column, SortOrder order)
		{
			try {
				// SendMessage(hWnd, LVM_GETHEADER, NULL, NULL);
				IntPtr hWnd = SendMessage(listView.Handle, 0x101F, 0, 0);
				
				HD_ITEM hdi = new HD_ITEM();
				hdi.mask = 0x0004; // HDI_FORMAT;
				for (int i = 0; i < listView.Columns.Count; i++) {
					// SendMessage(hWnd, HDM_GETITEMW, i, &hdi);
					SendMessage(hWnd, 0x120b, i, ref hdi);
					
					const int HDF_SORTUP = 0x400;
					const int HDF_SORTDOWN = 0x200;
					
					if (i != column || order == SortOrder.None) {
						hdi.fmt = hdi.fmt & ~(HDF_SORTUP | HDF_SORTDOWN);
					} else if (order == SortOrder.Ascending) { // 
						hdi.fmt = hdi.fmt & ~HDF_SORTDOWN | HDF_SORTUP;
					} else if (order == SortOrder.Descending) { // ~
						hdi.fmt = hdi.fmt & ~HDF_SORTUP | HDF_SORTDOWN;
					}
					
					// SendMessage(hWnd, HDM_SETITEMW, i, &hdi);
					SendMessage(hWnd, 0x120c, i, ref hdi);
				}
			} catch (Exception) {
			}
		}
		
		#endregion
		
		[DllImport("user32.dll", CharSet=CharSet.Auto)]
		internal static extern IntPtr SendMessage( IntPtr hWnd, UInt32 Msg, UInt32 wParam, UInt32 lParam);
		
		[DllImport("user32.dll", CharSet=CharSet.Auto)]
		internal static extern IntPtr SendMessage( IntPtr hWnd, UInt32 Msg, int wParam, ref HD_ITEM lParam);
	}
}
