using System;
using System.IO;
using System.Drawing;
using System.Windows.Forms;
using NaGet.Packages;
using NaGet.Packages.Install;

namespace AppliStation
{
	/// <summary>
	/// Description of PackageUninstallConfirmForm.
	/// </summary>
	public partial class PackageUninstallConfirmForm : Form
	{
		private InstalledPackage uninstallPackage;
		
		public InstalledPackage UninstallPackage {
			get { return uninstallPackage; }
			set {
				uninstallPackage = value;
				
				label2.Text = string.Format("{0}({1})", uninstallPackage.Name, uninstallPackage.Version);
				label2.Font = new Font(SystemFonts.DefaultFont.FontFamily, SystemFonts.DefaultFont.Size*1.5f);
				
				Icon icon = AppliStation.Util.PackageUtils.GetIconForPackage(uninstallPackage);
				if (icon != null) {
					iconLabel.Image = icon.ToBitmap();
					iconLabel.Size = icon.Size;
				}
			}
		}

		public PackageUninstallConfirmForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			// ǗҌœĂȂrunasKvɂ͂ȂȂ̂ŕ\Ȃ
			if (NaGet.Utils.IsAdministrators()) {
				runasCheckBox.Checked = false;
				runasCheckBox.Visible = false;
			}
		}
		
		#region runas֘A
		
		/// <summary>
		/// runasŎs邩ۂ
		/// </summary>
		public bool UseRunas {
			set {
				runasCheckBox.Checked = (! NaGet.Utils.IsAdministrators()) && value;
				
				updateUseRunas();
			}
			get {
				return runasCheckBox.Checked;
			}
		}
		
		/// <summary>
		/// IꂽpbP[W𒲍āARunasgׂȂԂ
		/// </summary>
		public bool GetShouldUseRunas()
		{
			if (NaGet.Utils.IsAdministrators()) {
				// ǗҌœĂꍇ͕sv
				return false;	
			}
			
			return (uninstallPackage.Type != InstallerType.ARCHIVE);
		}
		
		void RunasCheckBoxCheckedChanged(object sender, EventArgs e)
		{
			updateUseRunas();
		}
		
		private void updateUseRunas()
		{
			if (UseRunas) {
				System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PackagesInstallConfirmForm));
				okButton.Image = ((System.Drawing.Bitmap)(resources.GetObject("okButton.Image")));
			} else {
				okButton.Image = null;
			}
		}
		
		#endregion

	}
}
