using System;
using System.Drawing;
using System.Windows.Forms;
using NaGet.Packages;

namespace AppliStation
{
	/// <summary>
	/// Description of PackagesInstallConfirmForm.
	/// </summary>
	public partial class PackagesInstallConfirmForm : Form
	{
		private Package[] packages;
		
		private PackageListsManager pkgListMan;
		
		/// <summary>
		/// pbP[W̏W
		/// </summary>
		public Package[] Packages {
			get { return packages; }
			set {
				packages = value;
				
				updatePackagesListView();
			}
		}
		
		public PackageListsManager PkgListsManager {
			get { return pkgListMan; }
			set {
				pkgListMan = value;
				
				updatePackagesListView();
			}
		}
		
		public PackagesInstallConfirmForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
			
			// ǗҌœĂȂrunasKvɂ͂ȂȂ̂ŕ\Ȃ
			if (NaGet.Utils.IsAdministrators()) {
				runasCheckBox.Checked = false;
				runasCheckBox.Visible = false;
			}
		}
		
		private void updatePackagesListView()
		{
			packageListView.Items.Clear();
			
			if (packages != null && packages.Length > 0) {
				foreach (Package pkg in packages) {
					Package curPkg = null;
					if (pkgListMan != null) {	
						curPkg = pkgListMan.InstalledPkgList.GetPackageForName(pkg.Name);
						if (curPkg == null) curPkg = pkgListMan.SystemInstalledPkgList.GetPackageForName(pkg.Name);
					}
					string curVersion = (curPkg == null)? "-" : curPkg.Version;
					
					ListViewItem item = new ListViewItem(new string[]{pkg.Name, pkg.Version, curVersion});
					item.Tag = pkg;
					item.ToolTipText = pkg.Summary;
					item.Checked = true;
					
					packageListView.Items.Add(item);
				}
			}
			
			PackageListViewItemChecked(packageListView, null);
			packageListView.Refresh();
		}
		
		void PackageListViewItemChecked(object sender, ItemCheckedEventArgs e)
		{
			System.Windows.Forms.ListView.CheckedListViewItemCollection checkeds = packageListView.CheckedItems;
			
			okButton.Enabled = checkeds != null && checkeds.Count > 0;
		}
		
		AppliStation.Util.ListViewItemSortComparer packageListViewSortComparer;

		void PackageListViewColumnClick(object sender, ColumnClickEventArgs e)
		{
			SortOrder order = SortOrder.None;
			
			if (packageListViewSortComparer == null) {
				order = SortOrder.Ascending;
				packageListViewSortComparer = new AppliStation.Util.ListViewItemSortComparer(e.Column, order);
				packageListView.ListViewItemSorter = packageListViewSortComparer;
			} else {
				if (packageListViewSortComparer.Column == e.Column) {
					order = (packageListViewSortComparer.Order == SortOrder.Ascending)? SortOrder.Descending : SortOrder.Ascending;
					
					packageListViewSortComparer.Order = order;
				} else {
					order = packageListViewSortComparer.Order;
					packageListViewSortComparer.Column = e.Column;
				}
				
				packageListView.Sort();
			}
			AppliStation.Util.NativeMethods.ColumnHeader_SetSortState(packageListView, e.Column, order);
			
			// \[gΏۗ̐Ft
			try {
				// SendMessage(hWnd, LVM_SETSELECTEDCOLUMN, column, NULL);
				AppliStation.Util.NativeMethods.SendMessage(packageListView.Handle, 0x1000+140, (uint) e.Column, 0);
			} catch (Exception) {	
			}
		}
		
				
		void PackageListViewContextMenuStripOpening(object sender, System.ComponentModel.CancelEventArgs e)
		{
			System.Windows.Forms.ListView.CheckedIndexCollection coll = packageListView.CheckedIndices;
			selectAllPackagesStripMenuItem.Enabled = coll.Count < packages.Length;
			unselectAllPackagesStripMenuItem.Enabled = coll.Count > 0;
		}
				
		void SelectAllPackagesStripMenuItemClick(object sender, EventArgs e)
		{
			foreach (ListViewItem item in packageListView.Items) {
				item.Checked = true;
			}
			packageListView.Refresh();
		}
		
		void UnselectAllPackagesStripMenuItemClick(object sender, EventArgs e)
		{
			foreach (ListViewItem item in packageListView.CheckedItems) {
				item.Checked = false;
			}
			packageListView.Refresh();
		}
		
		/// <summary>
		/// CXg[悤IꂽpbP[W̔z
		/// </summary>
		public Package[] CheckedPackages {
			get {
				System.Collections.Generic.List<Package> pkgs = new System.Collections.Generic.List<Package>();
				foreach (ListViewItem item in packageListView.CheckedItems) {
					pkgs.Add((Package) item.Tag);
				}
				return pkgs.ToArray();
			}
		}
		
		#region runas֘A
		
		/// <summary>
		/// runasŎs邩ۂ
		/// </summary>
		public bool UseRunas {
			set {
				runasCheckBox.Checked = (! NaGet.Utils.IsAdministrators()) && value;
				
				updateUseRunas();
			}
			get {
				return runasCheckBox.Checked;
			}
		}
		
		/// <summary>
		/// IꂽpbP[W𒲍āARunasgׂȂԂ
		/// </summary>
		public bool GetShouldUseRunas()
		{
			if (NaGet.Utils.IsAdministrators()) {
				// ǗҌœĂꍇ͕sv
				return false;	
			} else if (NaGet.Utils.IsUACEnabled()) {
				// UACKpĂꍇ͕Wł͕svƂ
				return false;	
			}
			
			bool useRunas = false;
			foreach (Package pkg in CheckedPackages) {
				if (pkg.Type != InstallerType.ARCHIVE) {
					useRunas = true;
					break;
				}
			}
			return useRunas;
		}
		
		void RunasCheckBoxCheckedChanged(object sender, EventArgs e)
		{
			updateUseRunas();
		}
		
		private void updateUseRunas()
		{
			if (UseRunas) {
				System.ComponentModel.ComponentResourceManager resources = new System.ComponentModel.ComponentResourceManager(typeof(PackagesInstallConfirmForm));
				okButton.Image = ((System.Drawing.Bitmap)(resources.GetObject("okButton.Image")));
			} else {
				okButton.Image = null;
			}
		}
		
		#endregion


	}
}
