using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.IO;

namespace AppliStation
{
	class Program
	{
		Form splashScreen;
		
		PackageListViewForm form;
		
		/// <summary>
		/// AvP[ṼIvV
		/// </summary>
		Dictionary<string, object> appArgs;
		
		string[] restAppArgs;
		
		public Program()
		{
			appArgs = new Dictionary<string, object>();
			appArgs["noupdate"] = false;
			appArgs["cmd"] = string.Empty;
			appArgs["pkgsref"] = string.Empty;
			
			form = new PackageListViewForm();
		}
		
		void RunNormal()
		{
			form.Load += delegate(object sender, EventArgs e) {
				hideSplashScreen();
				form.updateActionInvoke(((bool)appArgs["noupdate"]) != true);
				
				form.UpdatePackageList();
			};
			Application.Run(form);
		}
		
		void RunInstall()
		{
			try {
				NaGet.Packages.Package[] pkgs = NaGet.Utils.GetDeserializedObject<NaGet.Packages.Package[]>((string) appArgs["pkgsref"]);
				
				hideSplashScreen();
				form.installActionInvoke(pkgs);
			} catch (UnauthorizedAccessException e) {
				MessageBox.Show(string.Format("ǗҌɏiĂȂAsɖ肪܂B\n(ڍ:{0})", e.Message),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			} catch (FileNotFoundException e) {
				MessageBox.Show(string.Format("\tgwt@C{0}܂", e.FileName),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		
		void RunUninstall()
		{
			try {
				NaGet.Packages.Install.InstalledPackage[] pkgs = NaGet.Utils.GetDeserializedObject<NaGet.Packages.Install.InstalledPackage[]>((string) appArgs["pkgsref"]);
				
				hideSplashScreen();
				form.uninstallActionInvoke(pkgs);
			} catch (UnauthorizedAccessException e) {
				MessageBox.Show(string.Format("ǗҌɏiĂȂAsɖ肪܂B\n(ڍ:{0})", e.Message),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			} catch (FileNotFoundException e) {
				MessageBox.Show(string.Format("\tgwt@C{0}܂", e.FileName),
				                Application.ProductName, MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		
		private void hideSplashScreen()
		{
			if (splashScreen != null && splashScreen.Visible) {
				splashScreen.Hide();
				splashScreen.Dispose();
			}
		}
		
		public void Run(string[] args)
		{
			parseArgs(args);
			
			switch ((string) appArgs["cmd"]) {
				case "install":
					RunInstall();
					break;
				case "uninstall":
					RunUninstall();
					break;
				default:
					RunNormal();
					break;
			}
		}
		
		private void parseArgs(string[] args)
		{
			ArgParse parser = new ArgParse(appArgs);
			restAppArgs = parser.Parse(args);
		}
		
		[STAThread]
		public static void Main(string[] args)
		{
			Form splashScreen = null;
			
			try {
				if (args.Length <= 0) { // HACK p[X̎Ԃ҂ĂȂ̂ň̗Lŕ\𔻒f
					splashScreen = new Form();
					splashScreen.FormBorderStyle = FormBorderStyle.None;
					splashScreen.BackgroundImage = System.Drawing.Bitmap.FromFile(Path.Combine(Path.GetDirectoryName(Application.ExecutablePath), "SplashScreen.png"));
					splashScreen.Size = splashScreen.BackgroundImage.Size;
					splashScreen.ShowIcon = false;
					splashScreen.ShowInTaskbar = false;
					splashScreen.StartPosition = FormStartPosition.CenterScreen;
					splashScreen.Show();
				}
				
				ToolStripManager.VisualStylesEnabled = false; // ToolStripLunaŐȂȂ悤
				Application.EnableVisualStyles(); // LunaVistãfUCL
				
				Application.ThreadException += AppliStation.Util.ExceptionDialogForm.Application_ThrowException;
				System.Threading.Thread.GetDomain().UnhandledException += AppliStation.Util.ExceptionDialogForm.Application_ThrowException;
				
				Program prog = new Program();
				prog.splashScreen = splashScreen;
				prog.Run(args);
			} catch (Exception e) {
				AppliStation.Util.ExceptionDialogForm.Application_ThrowException(null, new System.Threading.ThreadExceptionEventArgs(e));
			} finally {
				if (splashScreen != null) {
					splashScreen.Dispose();
				}
			}
		}
	}
}
