using System;
using System.Text;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;
using System.Diagnostics;

namespace NaGet.InteropServices
{	
	/// <summary>
	/// ShellLink̍XVtO
	/// </summary>
	[Flags]
	public enum ShellLinkResolve : uint
	{
		// AnyMatch = 0x02, // winMe,win2kȍ~
		
		/// <summary>
		/// MSIĂ
		/// </summary>
		InvokeMSI = 0x80,
		/// <summary>
		/// ǐՋ֎~
		/// </summary>
		NoLinkInfo = 0x40,
		/// <summary>
		/// N̉łȂƂ_CAO\Ȃ
		/// </summary>
		NoUi = 0x01,
		NoUiWithMsgPump = 0x101,
		/// <summary>
		/// Ñf[^XVsȂ
		/// </summary>
		NoUpdate = 0x07,
		/// <summary>
		/// Ȃ
		/// </summary>
		NoSearch = 0x10,
		NoTrack = 0x20,
		/// <summary>
		/// NXV
		/// </summary>
		Update = 0x04,
	}
	
	[ComImport()]
	[Guid("000214F9-0000-0000-C000-000000000046")]
	[InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
	public interface IShellLinkW
	{
		void GetPath([MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszFile,
		             int cchMaxPath, IntPtr pfd, uint fFlags);
		
		void GetIDList(out IntPtr ppidl);
		void SetIDList(IntPtr pidl);
		
		void GetDescription([MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszDesc,
		                         int cchMaxPath);
		void SetDescription(string pszDesc);
		
		void GetWorkingDirectory([MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszDir,
		                         int cchMaxPath);
		void SetWorkingDirectory(string pszDir);
		
		void GetArguments([MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszArgs,
		                         int cchMaxPath);
		void SetArguments(string pszArgs);
		
		void GetHotkey(out short pwHotkey);
		void SetHotkey(short pwHotkey);
		
		void GetShowCmd(out uint piShowCmd);
		void SetShowCmd(uint piShowCmd);
		
		void GetIconLocation([MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszIconPath,
		                         int cchMaxPath, out int piIcon);
		void SetIconLocation(string pszIconPath, int iIcon);
		
		void SetRelativePath([MarshalAs(UnmanagedType.LPWStr)] StringBuilder pszPath,
		                         int cchMaxPath, uint dwReserved);
		
		void Resolve(IntPtr hWnd, ShellLinkResolve fFlag);
				
		void SetPath(string pszFile);
	}

	/// <summary>
	/// VFN(V[gJbg)̃JvZNX
	/// </summary>
	public class ShellLink : IDisposable
	{
		/// <summary>
		/// VFNCOMIuWFNg
		/// </summary>
		protected IShellLinkW shellLink;
		
		/// <summary>
		/// VFNGUID
		/// </summary>
		public const string ShellLinkGuid = "00021401-0000-0000-C000-000000000046";
		
		protected const int MAX_PATH = 260;
		
		public ShellLink()
		{
			Type shellLinkType = Type.GetTypeFromCLSID(new Guid(ShellLinkGuid));
			shellLink = (IShellLinkW) Activator.CreateInstance(shellLinkType);
		}
		
		public ShellLink(string path) : this()
		{
			if (! System.IO.File.Exists(path)) {
				throw new System.IO.FileNotFoundException("File does not found", path);
			}
			
			ToPersistFile().Load(path, 0);
			Resolve(IntPtr.Zero, ShellLinkResolve.NoUpdate | ShellLinkResolve.NoUi);
		}
		
		/// <summary>
		/// VFN͉̉
		/// </summary>
		/// <param name="hWnd">et[̃nh</param>
		/// <param name="fFlags">@</param>
		public void Resolve(IntPtr? hWnd, ShellLinkResolve fFlags)
		{
			shellLink.Resolve(hWnd ?? IntPtr.Zero, fFlags);
		}
		
		/// <summary>
		/// IPersistFileƂĎo
		/// </summary>
		/// <returns>IPersistFileɃLXgꂽCOMIuWFNg</returns>
		public IPersistFile ToPersistFile()
		{
			return (IPersistFile) shellLink;
		}
		
		/// <summary>
		/// NpX𓾂BR}hC𓾂邽߂ɂ
		/// </summary>
		/// <param name="fFlags">pX̃^Cv(1:8.3`; 2:UNCpX; 4:ϐϊȂ)</param>
		/// <returns>pX</returns>
		public string GetPath(uint fFlags)
		{
			StringBuilder sb = new StringBuilder(MAX_PATH);
			shellLink.GetPath(sb, sb.Capacity, IntPtr.Zero, fFlags);
			return sb.ToString();
		}
		
		/// <summary>
		/// NpX(擾ɂ͊ϐ͓WJ܂)
		/// </summary>
		public string Path {
			get { return GetPath(0x04); }
			set { shellLink.SetPath(value); }
		}
		
		/// <summary>
		/// N()
		/// </summary>
		public string Arguments {
			get {
				StringBuilder sb = new StringBuilder(MAX_PATH);
				shellLink.GetArguments(sb, sb.Capacity);
				return sb.ToString();
			}
			set { shellLink.SetArguments(value); }
		}
		
		/// <summary>
		/// ƃtH_
		/// </summary>
		public string WorkingDirectory {
			get {
				StringBuilder sb = new StringBuilder(MAX_PATH);
				shellLink.GetWorkingDirectory(sb, sb.Capacity);
				return sb.ToString();
			}
			set { shellLink.SetWorkingDirectory(value); }
		}
		
		/// <summary>
		/// EBhEX^C(ShowCmd̃bp)
		/// </summary>
		public ProcessWindowStyle WindowStyle
		{
			get {
				uint showcmd;
				shellLink.GetShowCmd(out showcmd);
				switch (showcmd) {
					case 3:
						return ProcessWindowStyle.Maximized;
					case 7:
						return ProcessWindowStyle.Minimized;
					case 1:
					default:
						return ProcessWindowStyle.Normal;
				}
			}
			set {
				switch (value) {
					case ProcessWindowStyle.Normal:
						shellLink.SetShowCmd(1);
						break;
					case ProcessWindowStyle.Maximized:
						shellLink.SetShowCmd(3);
						break;
					case ProcessWindowStyle.Minimized:
					case ProcessWindowStyle.Hidden:
						shellLink.SetShowCmd(7);
						break;
				}
			}
		}
		
		/// <summary>
		/// ACȐꏊ𓾂
		/// </summary>
		/// <param name="iconPath">ACR܂ރt@CpX</param>
		/// <param name="iconIndex">ACR̃CfbNX</param>
		public void GetIconLocation(out string iconPath, out int iconIndex)
		{
			StringBuilder sb = new StringBuilder(MAX_PATH);
			shellLink.GetIconLocation(sb, sb.Capacity, out iconIndex);
			iconPath = sb.ToString();
		}
		
		/// <summary>
		/// ACȐꏊݒ肷
		/// </summary>
		/// <param name="iconPath">ACR܂ރt@CpX</param>
		/// <param name="iconIndex">ACR̃CfbNX</param>
		public void SetIconLocation(string iconPath, int iconIndex)
		{
			shellLink.SetIconLocation(iconPath, iconIndex);
		}
		
		/// <summary>
		/// COMIuWFNg̊J
		/// </summary>
		public void Dispose()
		{
			if (shellLink != null) {
				Marshal.ReleaseComObject(shellLink);
				shellLink = null;
			}
		}

		/// <summary>
		/// VFN̒gvZXƂĎ擾BN̍ۂɗp
		/// </summary>
		/// <returns>vZXN񉻂ꂽVFN̏</returns>
		public ProcessStartInfo ToProcessStartInfo()
		{
			ProcessStartInfo procInfo = new ProcessStartInfo();
			procInfo.FileName = GetPath(0);
			procInfo.Arguments = Arguments;
			procInfo.WorkingDirectory = WorkingDirectory;
			procInfo.WindowStyle = WindowStyle;
			
			return procInfo;
		}
		
		/// <summary>
		/// vZX񂩂VFNIuWFNg𐶐
		/// </summary>
		/// <param name="procInfo">vZX</param>
		/// <returns>ꂽVFNIuWFNg</returns>
		public static ShellLink CreateFromProcessStartInfo(ProcessStartInfo procInfo)
		{
			ShellLink shelllink = new ShellLink();
			shelllink.Path = procInfo.FileName;
			shelllink.Arguments = procInfo.Arguments;
			shelllink.WorkingDirectory = procInfo.WorkingDirectory;
			shelllink.WindowStyle = procInfo.WindowStyle;
			
			return shelllink;
		}
	}
}
