// OpenCallbackConsole.cpp

#include "StdAfx.h"

#include "../../UI/Console/OpenCallbackConsole.h"	// pXύX

#include "../../UI/Console/ConsoleClose.h"			// pXύX
//#include "UserInputUtils.h"						// 폜

HRESULT COpenCallbackConsole::CheckBreak()
{
  if (NConsoleClose::TestBreakSignal())
    return E_ABORT;
  return S_OK;
}

HRESULT COpenCallbackConsole::SetTotal(const UInt64 *, const UInt64 *)
{
  return CheckBreak();
}

HRESULT COpenCallbackConsole::SetCompleted(const UInt64 *, const UInt64 *)
{
  return CheckBreak();
}
 
HRESULT COpenCallbackConsole::CryptoGetTextPassword(BSTR *password)
{
  PasswordWasAsked = true;
  RINOK(CheckBreak());
  if (!PasswordIsDefined)
  {
//    Password = GetPassword(OutStream);	// 폜
    CPasswordDialog dlg(FALSE);				// ǉ
    if (dlg.DoModal() == IDCANCEL)			// ǉ
	{
      Password = L"";
      return ERROR_PASSWORD_FILE;			// ǉ
    }
	Password = dlg.GetPassword();			// ǉ
    PasswordIsDefined = true;
  }
  CMyComBSTR temp(Password);
  *password = temp.Detach();
  return S_OK;
}

HRESULT COpenCallbackConsole::GetPasswordIfAny(UString &password)
{
  if (PasswordIsDefined)
    password = Password;
  return S_OK;
}

bool COpenCallbackConsole::WasPasswordAsked()
{
  return PasswordWasAsked;
}

void COpenCallbackConsole::ClearPasswordWasAskedFlag()
{
  PasswordWasAsked = false;
}

  
