/*
	ArcBZ2.cpp
		bzip2 file input/output class.
		by Yoshioka Tsuneo(QWF00133@nifty.ne.jp)
*/
/*	
	̃t@C̗pF
		̃\[Xt@C̗p͈؂܂B
		\[ẌꕔASpA񏤗pȂǖړI
		Ȃ̃vOŎRɎgpł܂B
		pubNEhCE\tgEFAƓlɈ܂B
	
	vO}̗v](ł͂܂)F
		\[XɉPׂ_΂m点B
		\[XR[hɃoOꍇ͕񍐂ĂB
		Ȃǂ܂狳ĂB
		fГIȏł\łB
		̃t@C𗘗pꍇ͂ȂׂĂB
*/
/*
	LICENSE of this file:
		There is no restriction for using this file.
		You can use this file in your software for any purpose.
		In other words, you can use this file as Public Domain Software.

	RECOMMENDATION for Programmer(not restriction):
		If you find points to improve code, please report me.
		If you find bug in source code, please report me.
		If you fixed bug, please teach me.
		I want any trivial information.
		If you use this file, please report me.
*/
#include "stdafx.h"
#include "arcbz2.h"
#include "util.h"
#include "bzlib.h"

CTarArcFile_BZip2::CTarArcFile_BZip2()
{
	m_pbzFile = NULL;
}
CTarArcFile_BZip2::~CTarArcFile_BZip2()
{
	close();
}
bool CTarArcFile_BZip2::open(const char *arcfile, const char *mode, int compress_level)
{
	m_arcfile = arcfile;
	char buf[16];
	bool bReadMode=(NULL!=strchr(mode,'r'));
	if(!bReadMode){
		_snprintf(buf,COUNTOF(buf),"%s%d",mode,compress_level);
		mode=buf;	//[h̕ւ
	}
	BZFILE * f = BZ2_bzopen(arcfile, mode);
	m_pbzFile = f;
	return (f != NULL);
}
size64 CTarArcFile_BZip2::read(void *buf, size64 size)
{
	return BZ2_bzread(m_pbzFile, buf, (size_t)size);	//TODO:size lost
}
size64 CTarArcFile_BZip2::write(void *buf, size64 size)
{
	return BZ2_bzwrite(m_pbzFile, buf, (size_t)size);	//TODO:size lost
}
void CTarArcFile_BZip2::close()
{
	if(m_pbzFile){
		BZ2_bzclose(m_pbzFile);
		m_pbzFile = NULL;
	}
}
std::string CTarArcFile_BZip2::get_orig_filename(){
	if(! m_orig_filename.empty()){return m_orig_filename;}
	std::string fname = get_filename(m_arcfile.c_str());
	if(fname.length()>4 && stricmp(fname.substr(fname.length()-4).c_str(),".bz2") == 0){
		return fname.substr(0, fname.length()-4);
	}
	return fname + "_extracted";
}

