using System;
using System.ComponentModel;
using System.Drawing;
using System.Windows.Forms;

using NaGet.Packages;
using NaGet.Packages.Install;
using System.Reflection;

namespace AppliStation.PackageInfo
{
	/// <summary>
	/// Description of InstallerInfoForm.
	/// </summary>
	public partial class InstallerInfoForm : UserControl
	{
		private Installer inst;
		
		public InstallerInfoForm()
		{
			//
			// The InitializeComponent() call is required for Windows Forms designer support.
			//
			InitializeComponent();
		}
		
		public Installer SelectedObject {
			get { return inst; }
			set {
				inst = value;
				updateInst();
			}
		}
		
		private void updateInst()
		{
			installerUrlTextBox.Text = (inst == null || inst.Url == null)?
				string.Empty : inst.Url.Href;
						
			osValueLabel.Text = PackageDescripter.GetOSValueLabel(inst.Platform);
			archValueLabel.Text = PackageDescripter.GetArchValueLabel(inst.Platform);
			
			cannotRunLabel.Visible = ! ((inst.Platform == null) || inst.Platform.IsRunnable());
		}
	}
}
