﻿using System;
using System.ComponentModel;
using System.Xml.Serialization;
using System.Collections.Generic;

namespace NaGet.Packages
{
	/// <summary>
	/// レポジトリのリストを表現するクラス
	/// </summary>
	public class RepositoriesList
	{
		/// <summary>
		/// レポジトリの配列
		/// </summary>
		public RepositoryInfo[] Repositories = null;
		
		/// <summary>
		/// デフォルトコンストラクタ
		/// </summary>
		public RepositoriesList()
		{
		}
		
		/// <summary>
		/// 有効なレポジトリの配列を返す
		/// </summary>
		[XmlIgnore]
		public IEnumerable<RepositoryInfo> EnabledRepositories {
			get {
				foreach (RepositoryInfo repo in Repositories) {
					if (repo.Enabled) {
						yield return repo;
					}
				}
			}
		}
	}
	
	/// <summary>
	/// レポジトリで提供されるソフトリストのフォーマットを返す
	/// </summary>
	public enum RepositoryType : uint
	{
		/// <summary>
		/// AppliStation Native XML Format Version 1.0
		/// </summary>
		[XmlEnum(Name="ASNATIVEv1.0")]
		APPLISTATION_NATIVE_XML_1_0 = 0,
	}
	
	/// <summary>
	/// パッケージリストを提供するレポジトリの参照情報を格納するクラス
	/// </summary>
	public class RepositoryInfo
	{
		/// <summary>
		/// レポジトリの提供するソフトリストの名称
		/// </summary>
		[XmlAttribute]
		[ReadOnly(true)]
		public string Name;
		
		/// <summary>
		/// ソフトリストの形式
		/// </summary>
		[XmlAttribute]
		public RepositoryType Type;
		
		/// <summary>
		/// ソフトリストの取得先URL
		/// </summary>
		public LocationEntry Url;
		
		/// <summary>
		/// ソフトリストを読み取るか否か（無視するか否か）のフラグ。
		/// </summary>
		[XmlAttribute]
		[DefaultValue(true)]
		public bool Enabled = true;
	}
}
