#include <stdio.h>
#include <unistd.h>
#include <sys/stat.h>
#include <sys/types.h>
#include "config.h"

int write_file(const char *filename, char *start, unsigned int size)
{
	FILE *fp;

	fp = fopen(filename, "w");
	if (fp == NULL) {
		return 1;
	}

	fwrite(start, size, 1, fp);
	fclose(fp);
	return 0;
}

int main(int argc, char *argv[])
{
	char *start;
	unsigned int size;
	mode_t mode = S_IRWXU | S_IRGRP | S_IXGRP | S_IROTH | S_IXOTH;

	start = (char *)&_binary_built_in_Makefile_bin_start;
	size = (unsigned int) &_binary_built_in_Makefile_bin_size;
	write_file("Makefile", start, size);

	if ( mkdir("Buildscripts", mode) != 0 ){
		fprintf(stderr, "[Error] Cannot create directory.");
		return 1;
	}

	start = (char *)&_binary_built_in_Makefile_funcs_bin_start;
	size = (unsigned int) &_binary_built_in_Makefile_funcs_bin_size;
	write_file("Buildscripts/Makefile.funcs", start, size);

	start = (char *)&_binary_built_in_Makefile_pre_bin_start;
	size = (unsigned int) &_binary_built_in_Makefile_pre_bin_size;
	write_file("Buildscripts/Makefile.pre", start, size);

	start = (char *)&_binary_built_in_Makefile_post_bin_start;
	size = (unsigned int) &_binary_built_in_Makefile_post_bin_size;
	write_file("Buildscripts/Makefile.post", start, size);

	start = (char *)&_binary_built_in_Makefile_targets_bin_start;
	size = (unsigned int) &_binary_built_in_Makefile_targets_bin_size;
	write_file("Buildscripts/Makefile.targets", start, size);

	return 0;
}
