/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.action;

import java.io.Serializable;
import java.util.List;

import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Logger;
import org.jboss.seam.core.Conversation;
import org.jboss.seam.core.ConversationEntry;
import org.jboss.seam.core.ConversationList;
import org.jboss.seam.framework.EntityController;
import org.jboss.seam.international.StatusMessages;
import org.jboss.seam.international.StatusMessage.Severity;
import org.jboss.seam.log.Log;

public abstract class ApplicationAction extends EntityController  implements Serializable{
	@In
	protected StatusMessages statusMessages;
	
	@Logger
	protected Log log;
	
	@In(required=false)
	protected Conversation conversation;
	
	@In
	protected List<ConversationEntry> conversationList;
	
	public void destroyConversationByNameExceptCurrentConversation(String conversationDescription)
	{
		if (conversationList == null)
		{
			return;
		}
		
		for (ConversationEntry entry : conversationList) {			
			if (entry.getDescription().equals(conversationDescription) &&
					!entry.getId().equals(conversation.getId()))
			{
				log.warn("destroy conversation {0}. current conversation {1}", entry.getId(), conversation.getId());
				entry.destroy();
			}
					
		}
	}	
	
	public void addInfoMessage(String message, Object... param)
	{
		statusMessages.add(Severity.INFO, String.format(message, param));
	}
	
	public void addWarnMessage(String message, Object... param)
	{
		statusMessages.add(Severity.WARN, String.format(message, param));
	}
	
	public void addErrorMessage(String message, Object... param)
	{
		statusMessages.add(Severity.ERROR, String.format(message, param));
	}
	
	public void addFatalMessage(String message, Object... param)
	{
		statusMessages.add(Severity.FATAL, String.format(message, param));
	}

	public Conversation getConversation() {
		return conversation;
	}

	public void setConversation(Conversation conversation) {
		this.conversation = conversation;
	}

	public List<ConversationEntry> getConversationList() {
		return conversationList;
	}

	public void setConversationList(List<ConversationEntry> conversationList) {
		this.conversationList = conversationList;
	}

}
