/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.action;

import java.util.Iterator;

import org.jboss.seam.annotations.Name;
import org.jboss.seam.core.ConversationEntry;

@Name("menuAction")
public class MenuAction extends ApplicationAction {

	public String orderRegistClicked()
	{
		if (conversationList != null)
		{
			for (Iterator<ConversationEntry> i=conversationList.iterator();i.hasNext();) {
				ConversationEntry entry = i.next();
				if (entry.getDescription().equals("order regist"))
				{
					log.warn("destroy conversation {0}. current conversation {1}", entry.getId(), conversation.getId());
					entry.destroy();
				}			
			}
			log.warn("--->{0}", conversationList.size());
		}
		
		return "/order/orderRegist.xhtml";
	}
}
