/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.action;

import java.util.List;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;

import applicationpattern.entity.Order;
import applicationpattern.query.ApplicationQuery;
import applicationpattern.query.OrderListQuery;
import applicationpattern.searchcondition.OrderListSearchCondition;
import applicationpattern.util.UrlUtil;

@Scope(ScopeType.PAGE)
@Name("orderListAction")
public class OrderListAction extends ApplicationListAction {
	private OrderListSearchCondition orderListSearchCondition = new OrderListSearchCondition();
	
	@DataModelSelection
	private Order selectedOrder;
	
	@DataModel
	private List<Order> orderListSearchResult;
	
	@In(create=true)
	private OrderListQuery orderListQuery;
	
	@Override
	public ApplicationQuery getQuery() {
		return orderListQuery;
	}

	@Override
	public void search() {
		orderListSearchResult = orderListQuery.getResultList();
		setSearchResultTotalCount(orderListQuery.getResultCount().intValue());		
	}
	
	public String showDetail()
	{
		return UrlUtil.getOrderRegistUrl(selectedOrder);
	}

	public Order getSelectedOrder() {
		return selectedOrder;
	}

	public void setSelectedOrder(Order selectedOrder) {
		this.selectedOrder = selectedOrder;
	}

	public List<Order> getOrderListSearchResult() {
		return orderListSearchResult;
	}

	public void setOrderListSearchResult(List<Order> orderListSearchResult) {
		this.orderListSearchResult = orderListSearchResult;
	}

	public OrderListQuery getOrderListQuery() {
		return orderListQuery;
	}

	public void setOrderListQuery(OrderListQuery orderListQuery) {
		this.orderListQuery = orderListQuery;
	}

	public OrderListSearchCondition getOrderListSearchCondition() {
		return orderListSearchCondition;
	}

	public void setOrderListSearchCondition(
			OrderListSearchCondition orderListSearchCondition) {
		this.orderListSearchCondition = orderListSearchCondition;
	}

}
