/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.action;

import java.util.Date;
import java.util.List;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.End;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.datamodel.DataModel;
import org.jboss.seam.annotations.datamodel.DataModelSelection;

import applicationpattern.dao.OrderDao;
import applicationpattern.entity.Order;
import applicationpattern.entity.OrderItem;
import applicationpattern.entity.OrderItemCompositeKey;

@Name("orderRegistAction")
@Scope(ScopeType.CONVERSATION)
public class OrderRegistAction extends ApplicationMasterAction {
	private Order order;
	
	private OrderItem orderItem;
	
	@In(create=true)
	private OrderDao orderDao;	

	@DataModel
	private List<OrderItem> orderItemList;
	
	@DataModelSelection
	private OrderItem selectedOrderItem;
	

	@Create	
	public void init()
	{
		if (getRequestId() != null)
		{
			order = orderDao.findById(Order.class, getRequestId());
			if (order == null)
			{
				order = new Order();				
				addErrorMessage("w肵No{0}݂͑܂", getRequestId());
			}
			else
			{
				orderItemList = order.getOrderItemList();
			}
		}
		else
		{
			order = new Order();
		}
		//destroyConversationByNameExceptCurrentConversation("order regist");
	}
	
	@End
	public void regist()	
	{	
		orderDao.persist(order);
		orderDao.flushAndRefreshOrder(order);		
		updateCreateAndLastUpdateDateForOrderItems(order);
		
		addInfoMessage("̓o^ɐ܂");
	}

	private void updateCreateAndLastUpdateDateForOrderItems(Order order) {
		Date updateDate = new Date();
		for (OrderItem item : order.getOrderItemList())
		{
			if (item.getCreatedDate() == null)
			{
				item.setCreatedDate(updateDate);
			}
			item.setLastUpdatedDate(updateDate);
		}
	}
	
	public void createNewOrderItem()
	{
		OrderItemCompositeKey id = new OrderItemCompositeKey();
		id.setId(new Long(order.getOrderItemList().size()));
		id.setOrderId(order.getId());
		
		orderItem = new OrderItem();
		orderItem.setId(id);
	}
	
	public String addNewOrderItem()
	{		
		int elementIndex = order.getOrderItemList().indexOf(orderItem);
		if (elementIndex != -1)
		{
			order.getOrderItemList().set(elementIndex, orderItem);
		}
		else
		{
			order.getOrderItemList().add(orderItem);
		}		
		orderItemList = order.getOrderItemList();
		return "/order/orderRegist.xhtml";
	}
	
	public String cancelRegistOrderItem()
	{
		return "/order/orderRegist.xhtml";
	}
	
	public void showDetailOrderItem()
	{
		orderItem = selectedOrderItem;
	}
	

	public Order getOrder() {
		return order;
	}

	public void setOrder(Order order) {
		this.order = order;
	}

	public OrderDao getOrderDao() {
		return orderDao;
	}

	public void setOrderDao(OrderDao orderDao) {
		this.orderDao = orderDao;
	}

	public OrderItem getOrderItem() {
		return orderItem;
	}

	public void setOrderItem(OrderItem orderItem) {
		this.orderItem = orderItem;
	}

	public List<OrderItem> getOrderItemList() {
		return orderItemList;
	}

	public void setOrderItemList(List<OrderItem> orderItemList) {
		this.orderItemList = orderItemList;
	}

	public OrderItem getSelectedOrderItem() {
		return selectedOrderItem;
	}

	public void setSelectedOrderItem(OrderItem selectedOrderItem) {
		this.selectedOrderItem = selectedOrderItem;
	}
}
