/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.action;

import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Create;
import org.jboss.seam.annotations.In;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;

import applicationpattern.dao.UserDao;
import applicationpattern.entity.User;
import applicationpattern.exception.OptimisticException;

@Name("userMasterAction")
@Scope(ScopeType.PAGE)
public class UserMasterAction extends ApplicationMasterAction{
	private User user;
	
	@In(create=true)
	private UserDao userDao;
	
	@Create
	public void init()
	{
		if (getRequestId() != null)
		{
			user = userDao.findById(User.class, getRequestId());
		}
		else
		{
			user = new User();
		}
	}
	
	public void regist()
	{
		userDao.persist(user);
		addInfoMessage("o^ɐ܂B");
	}
	
	public void update()
	{
		try
		{
			user = userDao.update(user);
			addInfoMessage("XVɐ܂B");
		}
		catch(OptimisticException e)
		{			
			addErrorMessage("XVɎs܂BXV悤ƂR[h͑̃[UɂXV܂BXVƂĎsĂB");
		}
		
	}

	public User getUser() {
		return user;
	}

	public void setUser(User user) {
		this.user = user;
	}

}
