/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.query;

import org.jboss.seam.annotations.web.RequestParameter;
import org.jboss.seam.framework.EntityQuery;

public abstract class ApplicationQuery<E> extends EntityQuery<E> {
	private Long resultCount = null; 
	
	@RequestParameter("firstResult")
	@Override
	public void setFirstResult(Integer firstResult) {
		if (firstResult == null) {
			firstResult = 0;
		}
		super.setFirstResult(firstResult);
	}

	@Override
	public boolean isNextExists() {
		return (getFirstResult() + getMaxResults() < getResultCount()); 
	}

	/**
	 * ݂̃y[Wڂ܂ł\Ă̂Ԃ܂B
	 * @return@݂̃y[W\Ă錏
	 */
	public int getPageLastCount()
	{
		if (getResultCount() < getNextFirstResult())
		{			
			return getResultCount().intValue();
		}
		else
		{
			return getNextFirstResult();	
		}
	}

	/**
	 * EntityQueryNG[𔭍sȂ߂̑[u
	 */
	@Override
	public Long getResultCount()
	{
		if (resultCount == null)
		{
			resultCount = super.getResultCount();
		}
		return resultCount;
	}
}
