/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.query;

import java.util.Arrays;

import org.jboss.seam.annotations.Name;

import applicationpattern.entity.User;

@Name("userListQuery")
public class UserListQuery extends ApplicationQuery<User>{
	private static final String EJBQL = "select u from User u";
	private static final String[] RESTRICTIONS = { 		
		"u.id = #{userListAction.userListSearchCondition.id}",
		"u.name = #{userListAction.userListSearchCondition.name}",
		"u.sex= #{userListAction.userListSearchCondition.sex}",
	};
	
	public UserListQuery() {
		setEjbql(EJBQL);		
		setRestrictionExpressionStrings(Arrays.asList(RESTRICTIONS));
		setMaxResults(5);
		setOrder("u.id asc");
	}
}
