/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.entity;

import java.io.Serializable;

import javax.persistence.Column;

public class OrderItemCompositeKey implements Serializable {
	@Column(name="ORDER_ID", nullable=false)
	private Long orderId;
	
	@Column(name="ID", nullable=false)
	private Long id;

	public Long getOrderId() {
		return orderId;
	}

	public void setOrderId(Long orderId) {
		this.orderId = orderId;
	}

	public Long getId() {
		return id;
	}

	public void setId(Long id) {
		this.id = id;
	}

	@Override
	public boolean equals(Object obj) {
		if (obj == null || !(obj instanceof OrderItemCompositeKey))
		{
			return false;
		}
		OrderItemCompositeKey anotherOrderItem = (OrderItemCompositeKey)obj; 
		if ( (this.getId() == null && anotherOrderItem.getId() == null) &&
				(this.getOrderId() == null && anotherOrderItem.getOrderId() == null) )
		{
			return true;
		}
						
		return (this.getOrderId().equals(anotherOrderItem.getOrderId())) &&
			   (this.getId().equals(anotherOrderItem.getId()));
	}
}
