/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern;

import org.jboss.seam.mock.DBUnitSeamTest;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Parameters;

public abstract class ApplicationDBUnitTest extends DBUnitSeamTest {
	private String getFixturePath()
	{
		return String.format("fixture/%s.dbunit.xml",
								getClass().getSimpleName());
	}
	
	@Override
	protected void prepareDBUnitOperations() {
		System.out.println("load fixture :"+getFixturePath());				
		beforeTestOperations.add(new DataSetOperation(getFixturePath()));
	}
	
	@BeforeClass
	public void beforeClass()
	{
		setDatabase("hsql");
		setBinaryDir("META-INF/testbinaries");
		setDatasourceJndiName("java:/DefaultDS");
	}

	@Override
	@Parameters({"database"})
	public void setDatabase(String database) {
		super.setDatabase(database);
	}

	@Override
	@Parameters({"datasourceJndiName"})
	public void setDatasourceJndiName(String datasourceJndiName) {
		super.setDatasourceJndiName(datasourceJndiName);
	}

	@Override
	@Parameters({"binaryDir"})
	public void setBinaryDir(String binaryDir) {
		super.setBinaryDir(binaryDir);
	}
}
