/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *  http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package applicationpattern.dao;

import java.text.SimpleDateFormat;
import java.util.Date;

import org.testng.Assert;
import org.testng.annotations.Test;

import applicationpattern.ApplicationDBUnitTest;
import applicationpattern.entity.User;
import applicationpattern.enums.Sex;

public class UserDaoTest extends ApplicationDBUnitTest{
	@Override
	protected void prepareDBUnitOperations() {
		beforeTestOperations.add(
				new DataSetOperation(
					"fixture/UserDaoTest.dbunit.xml"));
		
	}
	
	private void assertUser(User expectedUser, User actualUser)
	{
		Assert.assertEquals(actualUser.getId(), expectedUser.getId());
		Assert.assertEquals(actualUser.getName(), expectedUser.getName());
		Assert.assertEquals(actualUser.getSex(), expectedUser.getSex());
		Assert.assertEquals(actualUser.getVersion(), expectedUser.getVersion());
		Assert.assertEquals(actualUser.getCreatedDate(), expectedUser.getCreatedDate());
		Assert.assertEquals(actualUser.getLastUpdatedDate(), expectedUser.getLastUpdatedDate());		
	}
	
	private User createUser(Long id, String name, Sex sex, Long version, Date createdDate, Date lastUpdatedDate)
	{
		User user = new User();
		user.setId(id);
		user.setName(name);
		user.setSex(sex);
		user.setVersion(version);
		user.setCreatedDate(createdDate);
		user.setLastUpdatedDate(lastUpdatedDate);
		return user;
	}
	
	@Test
	public void testFindById() throws Exception
	{
		new ComponentTest()
		{
			@Override
			protected void testComponents() throws Exception {
				UserDao dao = (UserDao) getInstance(UserDao.class);
				User user = dao.findById(User.class, 1L);
				User expectedUser = createUser(1L, "test", Sex.MAN, 0L,new SimpleDateFormat("yyyy/MM/dd HH:mm:ss").parse("2009/01/01 00:00:00"), null );
				assertUser(expectedUser, user);
			}			
		}.run();
	}
}
