﻿//-------------------------------------------------------------------------------------------------
// File : asdxMisc.h
// Desc : Utility Moudle.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxTypedef.h>
#include <string>
#include <d3d12.h>


namespace asdx {

//-------------------------------------------------------------------------------------------------
//! @brief      ファイルパスを検索します.
//!
//! @param[in]      filePath        検索するファイスパス.
//! @param[out]     result          検索結果の格納先.
//! @retval true    ファイルを発見.
//! @retval false   ファイルが見つからなかった.
//! @memo 検索ルールは以下の通り.
//!      .\
//!      ..\
//!      ..\..\
//!      .\res\
//!      %EXE_DIR%\
//!      %EXE_DIR%\..\
//!      %EXE_DIR%\..\..\
//!      %EXE_DIR%\res\
//-------------------------------------------------------------------------------------------------
bool SearchFilePath( const char16* filePath, std::wstring& result );

//-------------------------------------------------------------------------------------------------
//! @brief      ディレクトリ名を取得します.
//!
//! @param[in]      filePath        ファイルパス.
//! @return     指定されたファイルパスからディレクトリ名を抜き出します.
//-------------------------------------------------------------------------------------------------
std::wstring GetDirectoryPath( const char16* fielPath );

//-------------------------------------------------------------------------------------------------
//! @brief      拡張子を取得します.
//!
//! @param[in]      filePath        ファイルパス.
//! @return     指定されたファイルパスから拡張子を抜き出します.
//-------------------------------------------------------------------------------------------------
std::wstring GetExt( const char16* filePath );

//-------------------------------------------------------------------------------------------------
//! @brief      実行ファイルのファイルパスを取得します.
//!
//! @return     実行ファイルのファイルパスを返却します.
//-------------------------------------------------------------------------------------------------
std::wstring GetExePath();

//-------------------------------------------------------------------------------------------------
//! @brief      指定されたファイルパスが存在するかチェックします.
//!
//! @param[in]      filePath        チェックするファイルパス.
//! @return     指定されたファイルパスが存在する場合はtrueを返却します.
//-------------------------------------------------------------------------------------------------
bool IsExistFilePath( const char16* filePath );

//-------------------------------------------------------------------------------------------------
//! @brief      指定されたフォルダパスが存在するかチェックします.
//!
//! @param[in]      folderPath      チェックするフォルダパス.
//! @return     指定されたフォルダパスが存在する場合はtrueを返却します.
//-------------------------------------------------------------------------------------------------
bool IsExistFolderPath( const char16* folderPath );

} // namespacec asdx
