﻿//-------------------------------------------------------------------------------------------------
// File : asdxConnector.h
// Desc : Connector Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxTypedef.h>


//-------------------------------------------------------------------------------------------------
// Linker
//-------------------------------------------------------------------------------------------------
#ifdef ASDX_AUTO_LINK
#pragma comment( lib, "ws2_32.lib" )
#endif//ASDX_AUTO_LINK


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// Connector class
///////////////////////////////////////////////////////////////////////////////////////////////////
class Connector
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    ///////////////////////////////////////////////////////////////////////////////////////////////
    // TargetInfo structure
    ///////////////////////////////////////////////////////////////////////////////////////////////
    struct TargetInfo
    {
        u16     Port;       //!< ポート番号です.
        u32     Address;    //!< IPアドレスです.
    };

    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    Connector();

    //---------------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------------
    ~Connector();

    //---------------------------------------------------------------------------------------------
    //! @brief      接続処理を行います.
    //!
    //! @param[in]      info        接続先情報です.
    //! @retval true    接続に成功.
    //! @retval false   接続に失敗.
    //---------------------------------------------------------------------------------------------
    bool Connect( const TargetInfo& info );

    //---------------------------------------------------------------------------------------------
    //! @brief      切断処理を行います.
    //---------------------------------------------------------------------------------------------
    void Close();

    //---------------------------------------------------------------------------------------------
    //! @brief      接続してしているかどうかをチェックします.
    //!
    //! @retval true    接続状態です.
    //! @retval false   切断状態です.
    //---------------------------------------------------------------------------------------------
    bool IsConnect();

    //---------------------------------------------------------------------------------------------
    //! @brief      送信処理を行います.
    //!
    //! @param[in]      pBuffer     送信データ.
    //! @param[in]      size        送信データサイズ.
    //! @retval true    送信に成功.
    //! @retval false   送信に失敗.
    //---------------------------------------------------------------------------------------------
    bool Write( const void* pBuffer, u32 size );

    //---------------------------------------------------------------------------------------------
    //! @brief      受信処理を行います.
    //!
    //! @param[out]     pBuffer     受信データ.
    //! @param[in]      size        読み取りデータサイズ.
    //! @retval true    受信に成功.
    //! @retval false   受信に失敗.
    //---------------------------------------------------------------------------------------------
    bool Read( void* pBuffer, u32 size );

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    volatile bool   m_IsConnected;      //!< 接続済みフラグ.
    volatile bool   m_IsReady;          //!< 準備済みフラグ.
    uptr            m_SrcSocket;        //!< 入力ソケット.
    uptr            m_DstSocket;        //!< 出力ソケット.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};

} // namespace asdx