﻿//-------------------------------------------------------------------------------------------------
// File : asdxDeviceContext.h
// Desc : Device Context Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxRef.h>
#include <asdxFence.h>
#include <asdxCommandList.h>
#include <asdxDescHeap.h>
#include <d3d12.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// DeviceContext class
///////////////////////////////////////////////////////////////////////////////////////////////////
class DeviceContext : NonCopyable
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // private methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    DeviceContext();

    //---------------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------------
    ~DeviceContext();

    //---------------------------------------------------------------------------------------------
    //! @brief      初期化処理を行います.
    //---------------------------------------------------------------------------------------------
    bool Init( ID3D12Device* pDevice );

    //---------------------------------------------------------------------------------------------
    //! @brief      終了処理を行います.
    //---------------------------------------------------------------------------------------------
    void Term();

    //---------------------------------------------------------------------------------------------
    //! @brief      コマンドリストを実行します.
    //---------------------------------------------------------------------------------------------
    void Execute();

    //---------------------------------------------------------------------------------------------
    //! @brief      コマンドリストの完了を待機します.
    //---------------------------------------------------------------------------------------------
    void Wait( u32 mesc );

    //---------------------------------------------------------------------------------------------
    //! @brief      コマンドリストをクリアします.
    //---------------------------------------------------------------------------------------------
    void Clear( ID3D12PipelineState* pPSO );

    //---------------------------------------------------------------------------------------------
    //! @brief      サブリソースを更新します.
    //---------------------------------------------------------------------------------------------
    bool UpdateSubRes( 
        ID3D12Resource*         pResource,
        const u32               firstSubResource,
        const u32               subResourceCount,
        D3D12_SUBRESOURCE_DATA* pSrcData );

    //---------------------------------------------------------------------------------------------
    //! @brief      遷移によるリソースバリアを設定します.
    //!
    //! @param[in]      pResource       リソース.
    //! @param[in]      before          変更前のリソース状態.
    //! @param[in]      after           変更後のリソース状態.
    //---------------------------------------------------------------------------------------------
    void Transition(
        ID3D12Resource* pResource,
        D3D12_RESOURCE_STATES before,
        D3D12_RESOURCE_STATES after);

    //---------------------------------------------------------------------------------------------
    //! @brief      コマンドキューを取得します.
    //---------------------------------------------------------------------------------------------
    ID3D12CommandQueue* GetQueue() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      グラフィックスコマンドリストを取得します.
    //---------------------------------------------------------------------------------------------
    ID3D12GraphicsCommandList* GetGraphicsCommandList() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      コマンドアロケータを取得します.
    //---------------------------------------------------------------------------------------------
    ID3D12CommandAllocator* GetCommandAllocator() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      アロー演算子です.
    //---------------------------------------------------------------------------------------------
    ID3D12GraphicsCommandList* operator -> () const;

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    RefPtr<ID3D12CommandQueue>      m_Queue;            //!< コマンドキューです.
    GraphicsCommandList             m_Immediate;        //!< グラフィックスコマンドリストです.
    Fence                           m_Fence;            //!< フェンスです.
    bool                            m_IsInit;           //!< 初期化済みかどうか？

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};


} // namespacec asdx
