﻿//-------------------------------------------------------------------------------------------------
// File : asdxHash.h
// Desc : Hash Key Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxTypedef.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// Crc32 class
///////////////////////////////////////////////////////////////////////////////////////////////////
class Crc32
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    Crc32();

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      size        バッファサイズです.
    //! @param[in]      pBuffer     バッファです.
    //---------------------------------------------------------------------------------------------
    Crc32( const u32 size, const u8* pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      pBuffer     文字列です.
    //---------------------------------------------------------------------------------------------
    explicit Crc32( const char8*  pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      pBuffer     文字列です.
    //---------------------------------------------------------------------------------------------
    explicit Crc32( const char16* pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      value       ハッシュキー.
    //---------------------------------------------------------------------------------------------
    explicit Crc32( const u32 value );

    //---------------------------------------------------------------------------------------------
    //! @brief      コピーコンストラクタです.
    //!
    //! @param[in]      value       コピー元の値.
    //---------------------------------------------------------------------------------------------
    Crc32( const Crc32& value );

    //---------------------------------------------------------------------------------------------
    //! @brief      ハッシュキーを取得します.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    u32 GetHash() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      u32型へのキャストです.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    operator u32();

    //---------------------------------------------------------------------------------------------
    //! @brief      const u32型へのキャストです.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    operator const u32 () const;

    //---------------------------------------------------------------------------------------------
    //! @brief      等価比較演算子です.
    //!
    //! @param[in]      value       比較する値.
    //! @retval true    等価です.
    //! @retval false   非等価です.
    //---------------------------------------------------------------------------------------------
    bool    operator == ( const Crc32& value ) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      非等価比較演算子です.
    //!
    //! @param[in]      value       比較する値.
    //! @retval true    非等価です.
    //! @retval false   等価です.
    //---------------------------------------------------------------------------------------------
    bool    operator != ( const Crc32& value ) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      代入演算子です.
    //!
    //! @param[in]      value       代入する値.
    //! @return     代入結果を返却します.
    //---------------------------------------------------------------------------------------------
    Crc32&  operator =  ( const Crc32& value );

protected:
    //=============================================================================================
    // protected variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // protected methods.
    //=============================================================================================
    /* NOTHING */

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    u32     m_Hash;     //!< ハッシュキーです.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// Fnv1 class
///////////////////////////////////////////////////////////////////////////////////////////////////
class Fnv1
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    Fnv1();

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      size        バッファサイズです.
    //! @param[in]      pBuffer     バッファです.
    //---------------------------------------------------------------------------------------------
    Fnv1( const u32 size, const u8* pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      pBuffer     文字列です.
    //---------------------------------------------------------------------------------------------
    explicit Fnv1( const char8*  pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      pBuffer     文字列です.
    //---------------------------------------------------------------------------------------------
    explicit Fnv1( const char16* pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      value       ハッシュキー.
    //---------------------------------------------------------------------------------------------
    explicit Fnv1( const u32 value );

    //---------------------------------------------------------------------------------------------
    //! @brief      コピーコンストラクタです.
    //!
    //! @param[in]      value       コピー元の値.
    //---------------------------------------------------------------------------------------------
    Fnv1( const Fnv1& value );

    //---------------------------------------------------------------------------------------------
    //! @brief      ハッシュキーを取得します.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    u32 GetHash() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      u32型へのキャストです.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    operator u32();

    //---------------------------------------------------------------------------------------------
    //! @brief      const u32型へのキャストです.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    operator const u32 () const;

    //---------------------------------------------------------------------------------------------
    //! @brief      等価比較演算子です.
    //!
    //! @param[in]      value       比較する値.
    //! @retval true    等価です.
    //! @retval false   非等価です.
    //---------------------------------------------------------------------------------------------
    bool    operator == ( const Fnv1& value ) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      非等価比較演算子です.
    //!
    //! @param[in]      value       比較する値.
    //! @retval true    非等価です.
    //! @retval false   等価です.
    //---------------------------------------------------------------------------------------------
    bool    operator != ( const Fnv1& value ) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      代入演算子です.
    //!
    //! @param[in]      value       代入する値.
    //! @return     代入結果を返却します.
    //---------------------------------------------------------------------------------------------
    Fnv1&  operator =  ( const Fnv1& value );

protected:
    //=============================================================================================
    // protected variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // protected methods.
    //=============================================================================================
    /* NOTHING */

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    u32     m_Hash;     //!< ハッシュキーです.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// Fnv1a class
///////////////////////////////////////////////////////////////////////////////////////////////////
class Fnv1a
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    Fnv1a();

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      size        バッファサイズです.
    //! @param[in]      pBuffer     バッファです.
    //---------------------------------------------------------------------------------------------
    Fnv1a( const u32 size, const u8* pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      pBuffer     文字列です.
    //---------------------------------------------------------------------------------------------
    explicit Fnv1a( const char8*  pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      pBuffer     文字列です.
    //---------------------------------------------------------------------------------------------
    explicit Fnv1a( const char16* pBuffer );

    //---------------------------------------------------------------------------------------------
    //! @brief      引数付きコンストラクタです.
    //!
    //! @param[in]      value       ハッシュキー.
    //---------------------------------------------------------------------------------------------
    explicit Fnv1a( const u32 value );

    //---------------------------------------------------------------------------------------------
    //! @brief      コピーコンストラクタです.
    //!
    //! @param[in]      value       コピー元の値.
    //---------------------------------------------------------------------------------------------
    Fnv1a( const Fnv1a& value );

    //---------------------------------------------------------------------------------------------
    //! @brief      ハッシュキーを取得します.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    u32 GetHash() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      u32型へのキャストです.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    operator u32();

    //---------------------------------------------------------------------------------------------
    //! @brief      const u32型へのキャストです.
    //!
    //! @return     ハッシュキーを返却します.
    //---------------------------------------------------------------------------------------------
    operator const u32 () const;

    //---------------------------------------------------------------------------------------------
    //! @brief      等価比較演算子です.
    //!
    //! @param[in]      value       比較する値.
    //! @retval true    等価です.
    //! @retval false   非等価です.
    //---------------------------------------------------------------------------------------------
    bool    operator == ( const Fnv1a& value ) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      非等価比較演算子です.
    //!
    //! @param[in]      value       比較する値.
    //! @retval true    非等価です.
    //! @retval false   等価です.
    //---------------------------------------------------------------------------------------------
    bool    operator != ( const Fnv1a& value ) const;

    //---------------------------------------------------------------------------------------------
    //! @brief      代入演算子です.
    //!
    //! @param[in]      value       代入する値.
    //! @return     代入結果を返却します.
    //---------------------------------------------------------------------------------------------
    Fnv1a&  operator =  ( const Fnv1a& value );

protected:
    //=============================================================================================
    // protected variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // protected methods.
    //=============================================================================================
    /* NOTHING */

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    u32     m_Hash;     //!< ハッシュキーです.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};

} // namespace asdx
