﻿#pragma once
//-------------------------------------------------------------------------------------------------
// File : asdxResTexture.h
// Desc : Resource Texture Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxSurface.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// RESTEXTURE_OPTION enum
///////////////////////////////////////////////////////////////////////////////////////////////////
enum RESTEXTURE_OPTION
{
    RESTEXTURE_OPTION_NONE    = 0,
    RESTEXTURE_OPTION_CUBEMAP = 0x1 << 0,
    RESTEXTURE_OPTION_VOLUME  = 0x1 << 1,
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// ResTexture structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct ResTexture
{
    u32         Width;
    u32         Height;
    u32         Depth;
    u32         SurfaceCount;
    u32         MipMapCount;
    u32         Format;
    u32         Option;
    Surface*    pSurfaces;

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    ResTexture()
    : Width         ( 0 )
    , Height        ( 0 )
    , Depth         ( 0 )
    , SurfaceCount  ( 0 )
    , MipMapCount   ( 0 )
    , Format        ( 0 )
    , Option        ( RESTEXTURE_OPTION_NONE )
    , pSurfaces     ( nullptr )
    { /* DO_NOTHING */ }
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// TextureFactory class
///////////////////////////////////////////////////////////////////////////////////////////////////
class TextureFactory
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      テクスチャリソースを生成します.
    //!
    //! @param[in]      filename        テクスチャファイル名です.
    //! @param[out]     pResult         テクスチャリソースの格納先です.
    //! @retval true    生成に成功.
    //! @retval false   生成に失敗.
    //---------------------------------------------------------------------------------------------
    static bool Create( const char16* filename, ResTexture* pResult );

    //---------------------------------------------------------------------------------------------
    //! @brief      テクスチャリソースを破棄します.
    //!
    //! @param[in]      ptr         破棄するテクスチャリソースへのポインタ.
    //---------------------------------------------------------------------------------------------
    static void Dispose( ResTexture*& ptr );
};


} // namespace asdx
