﻿//-------------------------------------------------------------------------------------------------
// File : asdxStopWatch.h
// Desc : Stop Watch Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxTypedef.h>
#include <chrono>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// StopWatch class
///////////////////////////////////////////////////////////////////////////////////////////////////
class StopWatch
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    StopWatch()
    : m_Start()
    , m_End  ()
    { /* DO_NOTHING */ }

    //---------------------------------------------------------------------------------------------
    //! @brief      記録を開始します.
    //---------------------------------------------------------------------------------------------
    void Start()
    { m_Start = std::chrono::system_clock::now(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      記録を終了します.
    //---------------------------------------------------------------------------------------------
    void End()
    { m_End = std::chrono::system_clock::now(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      記録時間をリセットします.
    //---------------------------------------------------------------------------------------------
    void Reset()
    { m_Start = m_End = std::chrono::system_clock::now(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      経過時間をナノ秒単位で取得します.
    //---------------------------------------------------------------------------------------------
    s64 GetElpasedNanoSec() const
    { return std::chrono::duration_cast<std::chrono::nanoseconds>( m_End - m_Start ).count(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      経過時間をマイクロ秒単位で取得します.
    //---------------------------------------------------------------------------------------------
    s64 GetElapsedMicroSec() const
    { return std::chrono::duration_cast<std::chrono::microseconds>( m_End - m_Start ).count(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      経過時間をミリ秒単位で取得します.
    //---------------------------------------------------------------------------------------------
    s64 GetElapsedMilliSec() const
    { return std::chrono::duration_cast<std::chrono::milliseconds>( m_End - m_Start ).count(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      経過時間を秒単位で取得します.
    //---------------------------------------------------------------------------------------------
    s64 GetElapsedSec() const
    { return std::chrono::duration_cast<std::chrono::seconds>( m_End - m_Start ).count(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      経過時間を分単位で取得します.
    //---------------------------------------------------------------------------------------------
    s64 GetElapsedMin() const
    { return std::chrono::duration_cast<std::chrono::minutes>( m_End - m_Start ).count(); }

    //---------------------------------------------------------------------------------------------
    //! @brief      経過時間を時間単位で取得します.
    //---------------------------------------------------------------------------------------------
    s64 GetElapsedHour() const
    { return std::chrono::duration_cast<std::chrono::hours>( m_End - m_Start ).count(); }

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    std::chrono::time_point<std::chrono::system_clock> m_Start; //!< 開始時間
    std::chrono::time_point<std::chrono::system_clock> m_End;   //!< 終了時間.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};


} // namespace asdx
