﻿//-------------------------------------------------------------------------------------------------
// File : asdxSurface.h
// Desc : Surface Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxTypedef.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// Surface structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct Surface
{
    u32     Width;          //!< 横幅です.
    u32     Height;         //!< 縦幅です.
    u32     RowPitch;       //!< 1行あたりのデータサイズ(byte)です.
    u32     SlicePitch;     //!< 1スライスあたりのデータサイズ(byte)です.
    u8*     pPixels;        //!< ピクセルデータです.

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    Surface()
    : Width     ( 0 )
    , Height    ( 0 )
    , RowPitch  ( 0 )
    , SlicePitch( 0 )
    , pPixels   ( nullptr )
    { /* DO_NOTHING */ }
};

} // namespace asdx

