﻿//-------------------------------------------------------------------------------------------------
// File : asdxResMAT.h
// Desc : Project Asura MaterialSet Data Format (*.mts) Loader
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxResMaterial.h>


namespace asdx {

//-------------------------------------------------------------------------------------------------
//! @brief      MATファイルから読込します.
//!
//! @param[in]      filename        ファイル名です.
//! @param[out]     pResult         マテリアルセットリソースの格納先です.
//! @retval true    読込に成功.
//! @retval false   読込に失敗.
//-------------------------------------------------------------------------------------------------
bool LoadResMaterialFromMAT( const char16* filename, ResMaterial* pResult );

//-------------------------------------------------------------------------------------------------
//! @brief      MATファイルに保存します.
//!
//! @param[in]      filename        ファイル名です.
//! @param[in]      pMaterialSet    保存するマテリアルセットリソースです.
//! @retval true    保存に成功.
//! @retval false   保存に失敗.
//-------------------------------------------------------------------------------------------------
bool SaveResMaterialToMAT( const char16* filename, const ResMaterial* pMaterialSet );

} // namespace asdx

