﻿//-------------------------------------------------------------------------------------------------
// File : asdxResMSH,h
// Desc : Project Asura Mesh Format (*.msh) Loader
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxResMesh.h>


namespace asdx {

//-------------------------------------------------------------------------------------------------
//! @brief      MSHファイルからリソースメッシュを読込します.
//!
//! @param[in]      filename        ファイル名です.
//! @param[out]     pResult         リソースメッシュの格納先です.
//! @retval true    読込に成功.
//! @retval false   読込に失敗.
//-------------------------------------------------------------------------------------------------
bool LoadResMeshFromMSH( const char16* filename, ResMesh* pResult );

//-------------------------------------------------------------------------------------------------
//! @brief      リソースメッシュをMSHファイルに保存します.
//!
//! @param[in]      filename        ファイル名です.
//! @param[in]      pMesh           ファイルに保存するリソースメッシュです.
//! @retval true    保存に成功.
//! @retval false   保存に失敗.
//-------------------------------------------------------------------------------------------------
bool SaveResMeshToMSH( const char16* filename, const ResMesh* pMesh );

} // namespace asdx
