﻿//-------------------------------------------------------------------------------------------------
// File : asdxResTXM.h
// Desc : Project Asura Texture Map Data (*.txm) Loader
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxResTexture.h>


namespace asdx {

//-------------------------------------------------------------------------------------------------
//! @brief      TXMファイルからリソーステクスチャを読込します.
//!
//! @param[in]      filename        ファイル名です.
//! @param[out]     pResult         リソーステクスチャの格納先です.
//! @retval true    読込に成功.
//! @retval false   読込に失敗.
//-------------------------------------------------------------------------------------------------
bool LoadResTextureFromTXM( const char16* filename, ResTexture* pResult );

//-------------------------------------------------------------------------------------------------
//! @brief      リソーステクスチャをTXMファイルに保存します.
//!
//! @param[in]      filename        ファイル名です.
//! @param[in]      pTexture        ファイルに保存するリソーステクスチャです.
//! @retval true    保存に成功.
//! @retval false   保存に失敗.
//-------------------------------------------------------------------------------------------------
bool SaveResTextureToTXM( const char16* filename, const ResTexture* pTexture );

} // namespace asdx
