﻿//-------------------------------------------------------------------------------------------------
// File : asdxVertexBuffer.h
// Desc : Vertex Buffer Module.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------
#pragma once

//-------------------------------------------------------------------------------------------------
// Includes
//-------------------------------------------------------------------------------------------------
#include <asdxRef.h>
#include <d3d12.h>


namespace asdx {

///////////////////////////////////////////////////////////////////////////////////////////////////
// VertexBuffer class
///////////////////////////////////////////////////////////////////////////////////////////////////
class VertexBuffer : private NonCopyable
{
    //=============================================================================================
    // list of friend classes and methods.
    //=============================================================================================
    /* NOTHING */

public:
    //=============================================================================================
    // public variables.
    //=============================================================================================
    /* NOTHING */

    //=============================================================================================
    // public methods.
    //=============================================================================================

    //---------------------------------------------------------------------------------------------
    //! @brief      コンストラクタです.
    //---------------------------------------------------------------------------------------------
    VertexBuffer();

    //---------------------------------------------------------------------------------------------
    //! @brief      デストラクタです.
    //---------------------------------------------------------------------------------------------
    ~VertexBuffer();

    //---------------------------------------------------------------------------------------------
    //! @brief      初期化処理を行います.
    //!
    //! @param[in]      pDevice     デバイスです.
    //! @param[in]      size        頂点バッファサイズです.
    //! @param[in]      stride      1頂点あたりのサイズです.
    //! @param[in]      pVertices   頂点データです.
    //---------------------------------------------------------------------------------------------
    bool Init( ID3D12Device* pDevice, u64 size, u32 stride, const void* pVertices );

    //---------------------------------------------------------------------------------------------
    //! @brief      終了処理を行います.
    //---------------------------------------------------------------------------------------------
    void Term();

    //---------------------------------------------------------------------------------------------
    //! @brief      リソースを取得します.
    //!
    //! @return     リソースを返却します.
    //---------------------------------------------------------------------------------------------
    ID3D12Resource* GetResource() const;

    //---------------------------------------------------------------------------------------------
    //! @brief      頂点バッファビューを取得します.
    //!
    //! @return     頂点バッファビューを返却します.
    //---------------------------------------------------------------------------------------------
    D3D12_VERTEX_BUFFER_VIEW GetView() const;

private:
    //=============================================================================================
    // private variables.
    //=============================================================================================
    RefPtr<ID3D12Resource>      m_Resource;     //!< リソースです.
    D3D12_VERTEX_BUFFER_VIEW    m_View;         //!< 頂点バッファビューです.

    //=============================================================================================
    // private methods.
    //=============================================================================================
    /* NOTHING */
};


} // namespace asdx
