//-------------------------------------------------------------------------------------------------
// File : SimpleDef.hlsli
// Desc : Data Layout.
// Copyright(c) Project Asura. All right reserved.
//-------------------------------------------------------------------------------------------------

#define PI  (3.1415926535f)

///////////////////////////////////////////////////////////////////////////////////////////////////
// VSInput structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct VSInput
{
    float3  Position : POSITION;
    float3  Normal   : NORMAL;
    float2  TexCoord : TEXCOORD;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// VSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct VSOutput
{
    float4  Position : SV_POSITION;
    float3  Normal   : NORMAL;
    float2  TexCoord : TEXCOORD;
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// PSOutput structure
///////////////////////////////////////////////////////////////////////////////////////////////////
struct PSOutput
{
    float4  Color   : SV_TARGET0;
};


///////////////////////////////////////////////////////////////////////////////////////////////////
// Transform constant buffer
///////////////////////////////////////////////////////////////////////////////////////////////////
cbuffer Transform : register(b0)
{
    float4x4 World : packoffset(c0);
    float4x4 View  : packoffset(c4);
    float4x4 Proj  : packoffset(c8);
};

///////////////////////////////////////////////////////////////////////////////////////////////////
// Material constant buffer
///////////////////////////////////////////////////////////////////////////////////////////////////
cbuffer Material : register(b1)
{
    float3  Diffuse  : packoffset( c0 );
    float   Alpha    : packoffset( c0.w );
    float   Power    : packoffset( c1 );
    float3  Specular : packoffset( c1.y );
    float3  Emissive : packoffset( c2 );
}

Texture2D       ColorTexture : register( t0 );
SamplerState    ColorSmp     : register( s0 );
