/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample04.cpp
		uʓIDirectX Graphics̃vOv
--------------------------------------------------------------*/

#define STRICT				// ^`FbNɍsȂ
#define WIN32_LEAN_AND_MEAN	// wb_[炠܂gȂ֐Ȃ
#define WINVER        0x501	// Windows XPȍ~
#define _WIN32_WINNT  0x501 

#define SAFE_RELEASE(x)  { if(x) { (x)->Release(); (x)=NULL; } }

#define D3D_DEBUG_INFO		// Direct3DfobO̗L
#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓn

#include <windows.h>
#include <crtdbg.h>
#include <d3dx9.h>
#include <dxerr.h>

#include "resource.h"

// KvȃCuN
#pragma comment( lib, "d3d9.lib" )
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "d3dx9d.lib" )
#else
#pragma comment( lib, "d3dx9.lib" )
#endif
#pragma comment( lib, "dxerr.lib" )
#pragma comment( lib, "dxguid.lib" )
#pragma comment( lib, "Imm32.lib" )

/*-------------------------------------------
	O[oϐ(AvP[V֘A)
--------------------------------------------*/
HINSTANCE	g_hInstance		= NULL;	// CX^XEnh
HWND		g_hWindow		= NULL;	// EChEEnh
HMENU		g_hMenu			= NULL;	// j[Enh

WCHAR		g_szAppTitle[]	= L"Direct3D 9 Sample04";
WCHAR		g_szWndClass[]	= L"D3D9S04";

RECT		g_rectWindow;							// EChEE[hł̍Ō̈ʒu

// N̕`̈TCY
bool		g_bWindow = true;						// N̉ʃ[h

SIZE		g_sizeWindowMode	= { 640, 480 };		// ]ʃTCY(EChE)
SIZE		g_sizeFullMode	= { 1024, 768 };		// ]ʃTCY(tXN[)
D3DFORMAT	g_fmtDisplay[] = 						// ]fBXvCEtH[}bg
	{	D3DFMT_X8R8G8B8, D3DFMT_X1R5G5B5, D3DFMT_R5G6B5 };
D3DFORMAT	g_fmtRendTexter[] = 					// ]郌_OEeNX`̃tH[}bg
	{	D3DFMT_X8R8G8B8, D3DFMT_X1R5G5B5, D3DFMT_R5G6B5 };
D3DFORMAT	g_fmtDepthStencil = D3DFMT_D24S8;		// ][x/XeVobt@̃tH[}bg(D3DFMT_UNKNOWNŖgp)
UINT		g_Interval = D3DPRESENT_INTERVAL_IMMEDIATE;	// ]Present̎s[g

// AvP[V̓tO
bool		g_bActive		= false;	// ANeBu

/*-------------------------------------------
	O[oϐ(DirectX֘A)
--------------------------------------------*/

// C^[tFCX
LPDIRECT3D9				g_pD3D			= NULL; // Direct3DC^[tFCX
LPDIRECT3DDEVICE9		g_pD3DDevice	= NULL; // Direct3DDeviceC^[tFCX
D3DPRESENT_PARAMETERS	g_D3DPP;				// D3DDevice̐ݒ()

D3DPRESENT_PARAMETERS	g_D3DPPWindow;			// D3DDevice̐ݒ(EChEE[hp)
D3DPRESENT_PARAMETERS	g_D3DPPFull;			// D3DDevice̐ݒ(tXN[E[hp)

D3DFORMAT				g_fmtRendTexterWindow;	// _OEeNX`̃tH[}bg(EChEp)
D3DFORMAT				g_fmtRendTexterFull;	// _OEeNX`̃tH[}bg(tXN[p)

bool g_bDeviceLost = false;						// foCX̏tO

// XvCg@\
LPD3DXSPRITE			g_pD3DXSprite = NULL;	// XvCg
LPDIRECT3DTEXTURE9		g_pD3DTexture = NULL;	// XvCgɎgeNX`
WCHAR g_szSpriteFile[] = L"..\\..\\Media\\canvas.dds";	// XvCgɎg摜t@C

/*-------------------------------------------
	֐`
--------------------------------------------*/

LRESULT CALLBACK MainWndProc(HWND hWnd,UINT msg,UINT wParam,LONG lParam);

/*-------------------------------------------
	AvP[ViŏɈxĂ΂j
--------------------------------------------*/
HRESULT InitApp(HINSTANCE hInst)
{
	// AvP[ṼCX^XEnhۑ
	g_hInstance = hInst;

	// IME֎~
	ImmDisableIME(-1);	// ̃Xbhŋ֎~(imm32.libN)

	// EChEENX̓o^
	WNDCLASS wc;
	wc.style			= CS_HREDRAW | CS_VREDRAW;
	wc.lpfnWndProc		= (WNDPROC)MainWndProc;
	wc.cbClsExtra		= 0;
	wc.cbWndExtra		= 0;
	wc.hInstance		= hInst;
	wc.hIcon			= LoadIcon(hInst, (LPCTSTR)IDI_ICON1);
	wc.hCursor			= LoadCursor(NULL, IDC_ARROW);
	wc.hbrBackground	= (HBRUSH)(COLOR_WINDOW+1);
	wc.lpszMenuName		= g_bWindow ? MAKEINTRESOURCE(IDR_MENU1) : NULL;
	wc.lpszClassName	= g_szWndClass;

	if (!RegisterClass(&wc))
		return DXTRACE_ERR(L"InitApp", GetLastError());

	// CEEChE쐬
	g_rectWindow.top	= 0;
	g_rectWindow.left	= 0;
	g_rectWindow.right	= g_sizeWindowMode.cx;
	g_rectWindow.bottom	= g_sizeWindowMode.cy;
	AdjustWindowRect(&g_rectWindow, WS_OVERLAPPEDWINDOW, TRUE);
	g_rectWindow.right	= g_rectWindow.right - g_rectWindow.left;
	g_rectWindow.bottom	= g_rectWindow.bottom - g_rectWindow.top;
	g_rectWindow.top	= 0;
	g_rectWindow.left	= 0;

	RECT rect;
	if (g_bWindow)
	{
		// (EChEE[hp)
		rect.top	= CW_USEDEFAULT;
		rect.left	= CW_USEDEFAULT;
		rect.right	= g_rectWindow.right;
		rect.bottom	= g_rectWindow.bottom;
	}
	else
	{
		// (tXN[E[hp)
		rect.top	= 0;
		rect.left	= 0;
		rect.right	= g_sizeFullMode.cx;
		rect.bottom	= g_sizeFullMode.cy;

		g_hMenu = LoadMenu(g_hInstance, MAKEINTRESOURCE(IDR_MENU1));
	}

	g_hWindow = CreateWindow(g_szWndClass, g_szAppTitle,
		g_bWindow ? WS_OVERLAPPEDWINDOW : WS_POPUP,
			rect.left, rect.top, rect.right, rect.bottom,
			NULL, NULL, hInst, NULL);
	if (g_hWindow == NULL)
		return DXTRACE_ERR(L"InitApp", GetLastError());

	// EChE\
	ShowWindow(g_hWindow, SW_SHOWNORMAL);
	UpdateWindow(g_hWindow);

	return S_OK;
}

/*-------------------------------------------
	K؂Direct3DDevicetH[}bg̑I
--------------------------------------------*/
// foCX\͂̃`FbN
HRESULT CheckDeviceCaps(D3DCAPS9 *Caps);
// fBXvCƃobNEobt@̃tH[}bg̒
HRESULT SelectAdapterFormat(UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode);
// [x/XeVEobt@̃tH[}bg𒲂ׂ
HRESULT SelectDepthStencilFormat(UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode);
// _OEeNX`̃tH[}bg𒲂ׂ
HRESULT SelectRenderTexterFormat(UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode);
// tV[EA`GCAVO𒲂ׂ
HRESULT SelectMultiSampleType(UINT Adapter, D3DDEVTYPE Device);
// fBXvCE[h𒲂ׂ
HRESULT SelectDisplayMode(UINT Adapter);

HRESULT SelectD3DDevice(UINT &Adapter, D3DDEVTYPE &Device)
{
	// A_v^̑I
	Adapter = D3DADAPTER_DEFAULT;	// vC}EfBXvCEA_v^

	// foCX\͂̎擾
	D3DCAPS9 Caps; // \͂󂯎D3DCAPS9\

	HRESULT hr;
	Device = D3DDEVTYPE_HAL;	// HALfoCX`FbN
	hr = g_pD3D->GetDeviceCaps(Adapter, Device, &Caps);
	if (FAILED(hr) || FAILED(CheckDeviceCaps(&Caps)))
	{
		DXTRACE_ERR(L"SelectD3DDevice CheckDeviceCaps HAL", E_FAIL);

		Device = D3DDEVTYPE_REF;	// REFfoCX`FbN
		hr = g_pD3D->GetDeviceCaps(Adapter, Device, &Caps);
		if (FAILED(hr) || FAILED(CheckDeviceCaps(&Caps)))
			return DXTRACE_ERR(L"SelectD3DDevice CheckDeviceCaps REF", E_FAIL);
	}

	// ݂̃fBXvC̃tH[}bgȂǂ擾Ă
	D3DDISPLAYMODE dmode;
	hr = g_pD3D->GetAdapterDisplayMode(D3DADAPTER_DEFAULT, &dmode);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectD3DDevice GetAdapterDisplayMode", hr);

	// fBXvCƃobNEobt@̃tH[}bg̒
	hr = SelectAdapterFormat(Adapter, Device, dmode);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectD3DDevice SelectAdapterFormat", hr);

	// [x/XeVEobt@̃tH[}bg̒
	if (g_fmtDepthStencil != D3DFMT_UNKNOWN)
	{
		hr = SelectDepthStencilFormat(Adapter, Device, dmode);
		if (FAILED(hr))
			return DXTRACE_ERR(L"SelectD3DDevice SelectDepthStencilFormat", hr);
	}

	// _OEeNX`̃tH[}bg𒲂ׂ
	hr = SelectRenderTexterFormat(Adapter, Device, dmode);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectD3DDevice SelectRenderTexterFormat", hr);

	// ̑̃tH[}bg𒲂ׂ(Ȃ)

	// tV[EA`GCAVO𒲂ׂ
	hr = SelectMultiSampleType(Adapter, Device);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectD3DDevice SelectMultiSampleType", hr);

	// fBXvCE[h𒲂ׂ
	hr = SelectDisplayMode(Adapter);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectD3DDevice SelectDisplayMode", hr);

	return S_OK;
}

// foCX\͂̃`FbN
HRESULT CheckDeviceCaps(D3DCAPS9 *Caps)
{
	if (Caps->MaxStreams < 3)				// _Xg[
		return DXTRACE_ERR(L"CheckDeviceCaps MaxStreams < 3", E_FAIL);

	if (Caps->MaxPrimitiveCount < 0xFFFF)	// v~eBu
		return DXTRACE_ERR(L"CheckDeviceCaps MaxPrimitiveCount < 0xFFFF", E_FAIL);

	if (Caps->MaxVertexIndex < 0xFFF0)		// CfbNX
		return DXTRACE_ERR(L"CheckDeviceCaps MaxVertexIndex < 0xFFF0", E_FAIL);

//	if (Caps->VertexShaderVersion < D3DVS_VERSION(2, 0))	// _VF[_Eo[W
//		return DXTRACE_ERR(L"CheckDeviceCaps VertexShaderVersion < D3DVS_VERSION(2, 0)", E_FAIL);

	if (Caps->PixelShaderVersion < D3DPS_VERSION(2, 0))	// sNZEVF[_Eo[W
		return DXTRACE_ERR(L"CheckDeviceCaps PixelShaderVersion < D3DPS_VERSION(2, 0)", E_FAIL);

	return S_OK;
}

// fBXvCƃobNEobt@̃tH[}bg̒
HRESULT SelectAdapterFormat(UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode)
{
	HRESULT hr = S_OK;

	// EChEE[h
	ZeroMemory(&g_D3DPPWindow, sizeof(g_D3DPPWindow));
	g_D3DPPWindow.BackBufferCount			= 1;
	g_D3DPPWindow.SwapEffect				= D3DSWAPEFFECT_DISCARD;
	g_D3DPPWindow.hDeviceWindow				= g_hWindow;
	g_D3DPPWindow.Windowed					= TRUE;
	g_D3DPPWindow.PresentationInterval		= g_Interval;

	for (int i=0; i<sizeof(g_fmtDisplay)/sizeof(g_fmtDisplay[0]); i++)
	{
		hr = g_pD3D->CheckDeviceType(Adapter, Device, dmode.Format, g_fmtDisplay[i], TRUE);
		if (SUCCEEDED(hr))
		{
			g_D3DPPWindow.BackBufferFormat = g_fmtDisplay[i];
			break;
		}
	}
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectAdapterFormat CheckDeviceType Window", hr);

	// tXN[E[h
	ZeroMemory(&g_D3DPPFull, sizeof(g_D3DPPFull));
	g_D3DPPFull.BackBufferCount				= 1;
	g_D3DPPFull.SwapEffect					= D3DSWAPEFFECT_DISCARD;
	g_D3DPPFull.hDeviceWindow				= g_hWindow;
	g_D3DPPFull.Windowed					= FALSE;
	g_D3DPPFull.PresentationInterval		= g_Interval;
	
	for (int i=0; i<sizeof(g_fmtDisplay)/sizeof(g_fmtDisplay[0]); i++)
	{
		hr = g_pD3D->CheckDeviceType(Adapter, Device, g_fmtDisplay[i], g_fmtDisplay[i], FALSE);
		if (SUCCEEDED(hr))
		{
			g_D3DPPFull.BackBufferFormat = g_fmtDisplay[i];
			break;
		}
	}
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectAdapterFormat CheckDeviceType Full", hr);

	return S_OK;
}

// [x/XeVEobt@̃tH[}bg𒲂ׂ
HRESULT SelectDepthStencilFormat(UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode)
{
	HRESULT hr;

	// EChEE[h
	hr = g_pD3D->CheckDeviceFormat(Adapter, Device,
				dmode.Format, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, g_fmtDepthStencil);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectDepthStencilFormat CheckDeviceFormat DS Window", hr);

	hr = g_pD3D->CheckDepthStencilMatch(Adapter, Device,
				dmode.Format, g_D3DPPWindow.BackBufferFormat, g_fmtDepthStencil);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectDepthStencilFormat CheckDepthStencilMatch DS Window", hr);

	g_D3DPPWindow.EnableAutoDepthStencil = TRUE;
	g_D3DPPWindow.AutoDepthStencilFormat = g_fmtDepthStencil;

	// tXN[E[h
	hr = g_pD3D->CheckDeviceFormat(Adapter, Device,
				g_D3DPPFull.BackBufferFormat, D3DUSAGE_DEPTHSTENCIL, D3DRTYPE_SURFACE, g_fmtDepthStencil);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectDepthStencilFormat CheckDeviceFormat DS Full", hr);

	hr = g_pD3D->CheckDepthStencilMatch(Adapter, Device,
				g_D3DPPFull.BackBufferFormat, g_D3DPPFull.BackBufferFormat, g_fmtDepthStencil);
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectDepthStencilFormat CheckDepthStencilMatch DS Full", hr);

	g_D3DPPFull.EnableAutoDepthStencil = TRUE;
	g_D3DPPFull.AutoDepthStencilFormat = g_fmtDepthStencil;

	return S_OK;
}

// _OEeNX`̃tH[}bg𒲂ׂ
HRESULT SelectRenderTexterFormat(UINT Adapter, D3DDEVTYPE Device, D3DDISPLAYMODE dmode)
{
	HRESULT hr = S_OK;

	// EChEE[h
	g_fmtRendTexterWindow = D3DFMT_UNKNOWN;
	for (int i=0; i<sizeof(g_fmtRendTexter)/sizeof(g_fmtRendTexter[0]); i++)
	{
		hr = g_pD3D->CheckDeviceFormat(Adapter, Device,
				dmode.Format, D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, g_fmtRendTexter[i]);
		if (SUCCEEDED(hr))
		{
			hr = g_pD3D->CheckDepthStencilMatch(Adapter, Device,
						dmode.Format, g_fmtRendTexter[i], g_fmtDepthStencil);
			if (SUCCEEDED(hr))
			{
				g_fmtRendTexterWindow = g_fmtRendTexter[i];
				break;
			}
		}
	}
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectRenderTexterFormat Window", hr);

	// tXN[E[h
	g_fmtRendTexterFull = D3DFMT_UNKNOWN;
	for (int i=0; i<sizeof(g_fmtRendTexter)/sizeof(g_fmtRendTexter[0]); i++)
	{
		hr = g_pD3D->CheckDeviceFormat(Adapter, Device,
				g_D3DPPFull.BackBufferFormat,
				D3DUSAGE_RENDERTARGET, D3DRTYPE_TEXTURE, g_fmtRendTexter[i]);
		if (SUCCEEDED(hr))
		{
			hr = g_pD3D->CheckDepthStencilMatch(Adapter, Device,
					g_D3DPPFull.BackBufferFormat, g_fmtRendTexter[i], g_fmtDepthStencil);
			if (SUCCEEDED(hr))
			{
				g_fmtRendTexterFull = g_fmtRendTexter[i];
				break;
			}
		}
	}
	if (FAILED(hr))
		return DXTRACE_ERR(L"SelectRenderTexterFormat Full", hr);

	return S_OK;
}

// tV[EA`GCAVO𒲂ׂ
HRESULT SelectMultiSampleType(UINT Adapter, D3DDEVTYPE Device)
{
	D3DMULTISAMPLE_TYPE mst[] =
		{ D3DMULTISAMPLE_4_SAMPLES, D3DMULTISAMPLE_3_SAMPLES, D3DMULTISAMPLE_2_SAMPLES, D3DMULTISAMPLE_NONE };
	DWORD Quality;

	// EChEE[h
	for (int i=0; i<sizeof(mst)/sizeof(mst[0]); i++)
	{
		if (FAILED(g_pD3D->CheckDeviceMultiSampleType(Adapter, Device,
				g_D3DPPWindow.BackBufferFormat, TRUE, mst[i], &Quality)))
			continue;
		if (g_D3DPPWindow.EnableAutoDepthStencil == TRUE)
			if (FAILED(g_pD3D->CheckDeviceMultiSampleType(Adapter, Device,
					g_D3DPPWindow.AutoDepthStencilFormat, TRUE, mst[i], NULL)))
				continue;
		g_D3DPPWindow.MultiSampleType	= mst[i];
		g_D3DPPWindow.MultiSampleQuality = Quality - 1;
		break;
	}

	// tXN[E[h
	for (int i=0; i<sizeof(mst)/sizeof(mst[0]); i++)
	{
		if (FAILED(g_pD3D->CheckDeviceMultiSampleType(Adapter, Device,
				g_D3DPPFull.BackBufferFormat, FALSE, mst[i], &Quality)))
			continue;
		if (g_D3DPPWindow.EnableAutoDepthStencil == TRUE)
			if (FAILED(g_pD3D->CheckDeviceMultiSampleType(Adapter, Device,
					g_D3DPPFull.AutoDepthStencilFormat, FALSE, mst[i], NULL)))
				continue;
		g_D3DPPFull.MultiSampleType	= mst[i];
		g_D3DPPFull.MultiSampleQuality = Quality - 1;
		break;
	}

	return S_OK;
}

// fBXvCE[h𒲂ׂ
HRESULT SelectDisplayMode(UINT Adapter)
{
	// EChEE[h(ׂKvȂ)

	// tXN[E[h
	D3DDISPLAYMODE dmode = { 0, 0, 0, D3DFMT_UNKNOWN };
	int level = 1000000;
	int num = g_pD3D->GetAdapterModeCount(Adapter, g_D3DPPFull.BackBufferFormat);
	for (int i=0; i<num; i++)
	{
		// fBXvCE[h̗
		D3DDISPLAYMODE dm;
		g_pD3D->EnumAdapterModes(Adapter, g_D3DPPFull.BackBufferFormat, i, &dm);
		// ]̃[hƂ̌덷(܂K؂ȌvZł͂Ȃ)
		int l = abs((int)(g_sizeFullMode.cx  - dm.Width)) + abs((int)(g_sizeFullMode.cy  - dm.Height));
		if (l < level)
		{
			// K؂ȃ[hI
			dmode = dm;
			level = l;
		}
	}
	if (dmode.Format == D3DFMT_UNKNOWN)
		return DXTRACE_ERR(L"SelectDisplayMode EnumAdapterModes", E_FAIL);

	g_D3DPPFull.BackBufferWidth  = dmode.Width;
	g_D3DPPFull.BackBufferHeight = dmode.Height;

	return S_OK;
}

/*-------------------------------------------
	DirectX Graphics
--------------------------------------------*/
HRESULT InitDXGraphics(void)
{
	// Direct3DIuWFNg̍쐬
	g_pD3D = Direct3DCreate9(D3D_SDK_VERSION);
	if (g_pD3D == NULL)
		return DXTRACE_ERR(L"InitDXGraphics Direct3DCreate9", E_FAIL);

	// foCXݒ̑I
	UINT Adapter;
	D3DDEVTYPE Device;
	HRESULT hr = SelectD3DDevice(Adapter, Device);
	if (FAILED(hr))
		return DXTRACE_ERR(L"InitDXGraphics SelectD3DDevice", hr);

	// D3DDeviceIuWFNg̍쐬
	if (g_bWindow)
		g_D3DPP = g_D3DPPWindow;
	else
		g_D3DPP = g_D3DPPFull;

	hr = g_pD3D->CreateDevice(Adapter, Device, g_hWindow,
						D3DCREATE_HARDWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice);
	if (FAILED(hr))
	{
		hr = g_pD3D->CreateDevice(Adapter, Device, g_hWindow,
						D3DCREATE_SOFTWARE_VERTEXPROCESSING, &g_D3DPP, &g_pD3DDevice);
		if (FAILED(hr))
			return DXTRACE_ERR(L"InitDXGraphics CreateDevice", hr);
	}

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= g_D3DPP.BackBufferWidth;
	vp.Height	= g_D3DPP.BackBufferHeight;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	hr = g_pD3DDevice->SetViewport(&vp);
	if (FAILED(hr))
		return DXTRACE_ERR(L"InitDXGraphics SetViewport", hr);

	// XvCgɕ\eNX`̏
	hr = D3DXCreateTextureFromFile(g_pD3DDevice, g_szSpriteFile, &g_pD3DTexture);
	if (FAILED(hr))
		return DXTRACE_ERR(L"InitDXGraphics D3DXCreateTextureFromFile", hr);

	// XvCg@\̏
	hr = D3DXCreateSprite(g_pD3DDevice, &g_pD3DXSprite);
	if (FAILED(hr))
		return DXTRACE_ERR(L"InitDXGraphics D3DXCreateSprite", hr);

	return S_OK;
}

/*-------------------------------------------
	D3DɊǗȂIuWFNg̏
--------------------------------------------*/
HRESULT InitD3DObject(void)
{
	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnResetDevice();

	// _OEXe[g̐ݒ
	// Zobt@̐ݒ
	g_pD3DDevice->SetRenderState(D3DRS_ZENABLE,
		g_D3DPP.EnableAutoDepthStencil ? D3DZB_TRUE : D3DZB_FALSE);

	// }`TvO̐ݒ
	g_pD3DDevice->SetRenderState(D3DRS_MULTISAMPLEANTIALIAS,
		g_D3DPP.MultiSampleType != D3DMULTISAMPLE_NONE ? TRUE : FALSE);

	return S_OK;
}

/*--------------------------------------------
	ʂ̕`揈
--------------------------------------------*/
HRESULT Render(void)
{
	// V[̃NA
	g_pD3DDevice->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(g_pD3DDevice->BeginScene()))
	{
		// V[̕`(XvCg̕`)
		static int alpha=0;
		g_pD3DXSprite->Begin(D3DXSPRITE_ALPHABLEND | D3DXSPRITE_DONOTSAVESTATE);
		g_pD3DXSprite->Draw(g_pD3DTexture, NULL, NULL, NULL,
				D3DCOLOR_ARGB(alpha>255?511-alpha:alpha,255,255,255));
		alpha++; alpha &= 0x1FF;
		g_pD3DXSprite->End();

		// V[̕`I
		g_pD3DDevice->EndScene();
	}

	// V[̕\
	return g_pD3DDevice->Present(NULL, NULL, NULL, NULL);
}

/*-------------------------------------------
	D3DɊǗȂIuWFNg̏I
--------------------------------------------*/
HRESULT CleanupD3DObject(void)
{
	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnLostDevice();

	return S_OK;
}

/*-------------------------------------------
	EChEETCY̕ύX
--------------------------------------------*/
HRESULT ChangeWindowSize(void)
{
	// EChẼNCAg̈ɍ킹
	CleanupD3DObject();

	HRESULT hr = g_pD3DDevice->Reset(&g_D3DPP);
	if (FAILED(hr))
	{
		if (hr == D3DERR_DEVICELOST)
			g_bDeviceLost = true;
		else
			DestroyWindow(g_hWindow);
		return DXTRACE_ERR(L"ChangeWindowSize Reset", hr);
	}
	hr = InitD3DObject();
	if (FAILED(hr))
	{
		DestroyWindow(g_hWindow);
		return DXTRACE_ERR(L"ChangeWindowSize InitD3DObject", hr);
	}

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X		= 0;
	vp.Y		= 0;
	vp.Width	= g_D3DPP.BackBufferWidth;
	vp.Height	= g_D3DPP.BackBufferHeight;
	vp.MinZ		= 0.0f;
	vp.MaxZ		= 1.0f;
	hr = g_pD3DDevice->SetViewport(&vp);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"ChangeWindowSize SetViewport", hr);
		DestroyWindow(g_hWindow);
	}
	return hr;
}

/*-------------------------------------------
	ʃ[h̕ύX
--------------------------------------------*/
void ChangeDisplayMode(void)
{
	g_bWindow = !g_bWindow;

	CleanupD3DObject();

	if (g_bWindow)
	{
		g_D3DPP = g_D3DPPWindow;
	}
	else
	{
		g_D3DPP = g_D3DPPFull;
		GetWindowRect(g_hWindow, &g_rectWindow);
	}

	HRESULT hr = g_pD3DDevice->Reset(&g_D3DPP);
	if (FAILED(hr))
	{
		if (hr == D3DERR_DEVICELOST)
			g_bDeviceLost = true;
		else
			DestroyWindow(g_hWindow);
		DXTRACE_ERR(L"ChangeDisplayMode Reset", hr);
		return;
	}

	hr = InitD3DObject();
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"ChangeDisplayMode InitD3DObject", hr);
		DestroyWindow(g_hWindow);
		return;
	}

	if (g_bWindow)
	{
		SetWindowLong(g_hWindow, GWL_STYLE, WS_OVERLAPPEDWINDOW | WS_VISIBLE);
		if(g_hMenu != NULL)
		{
			SetMenu(g_hWindow, g_hMenu);
			g_hMenu = NULL;
		}
		SetWindowPos(g_hWindow, HWND_NOTOPMOST,
				g_rectWindow.left, g_rectWindow.top,
				g_rectWindow.right - g_rectWindow.left,
				g_rectWindow.bottom - g_rectWindow.top,
				SWP_SHOWWINDOW);
	}
	else
	{
		SetWindowLong(g_hWindow, GWL_STYLE, WS_POPUP | WS_VISIBLE);
		if(g_hMenu == NULL)
		{
			g_hMenu = GetMenu(g_hWindow);
			SetMenu(g_hWindow, NULL);
		}
	}
}

/*-------------------------------------------
	DirectX Graphics̏I(ɎsƂĂ΂)
--------------------------------------------*/
bool CleanupDXGraphics(void)
{
	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pD3DXSprite);
	SAFE_RELEASE(g_pD3DTexture);

	SAFE_RELEASE(g_pD3DDevice);
	SAFE_RELEASE(g_pD3D);

	return true;
}

/*-------------------------------------------
	AvP[V̏IiŌɌĂ΂j
--------------------------------------------*/
bool CleanupApp(void)
{
	// j[Enh̍폜
	if (g_hMenu)
		DestroyMenu(g_hMenu);

	// EChEENX̓o^
	UnregisterClass(g_szWndClass, g_hInstance);
	return true;
}

/*-------------------------------------------
	EBhE
--------------------------------------------*/
LRESULT CALLBACK MainWndProc(HWND hWnd, UINT msg, UINT wParam, LONG lParam)
{
	HRESULT hr = S_OK;

	switch(msg)
	{
	case WM_ACTIVATE:
		g_bActive = (LOWORD(wParam) != 0);
		break;

	case WM_DESTROY:
		// D3DɊǗȂIuWFNg̏I
		CleanupD3DObject();
		// DirectX Graphics̏I
		CleanupDXGraphics();
		// EChE
		PostQuitMessage(0);
		g_hWindow = NULL;
		return 0;

	// EChEETCY̕ύX
	case WM_SIZE:
		if (g_D3DPP.Windowed != TRUE)
			break;

		if (!g_pD3DDevice || wParam == SIZE_MINIMIZED)
			break;
		g_D3DPP.BackBufferWidth  = LOWORD(lParam);
		g_D3DPP.BackBufferHeight = HIWORD(lParam);
		if(g_bDeviceLost)
			break;
		if (wParam == SIZE_MAXIMIZED || wParam == SIZE_RESTORED)
			ChangeWindowSize();
		break;

	case WM_SETCURSOR:
		if (g_D3DPP.Windowed != TRUE)
		{
			SetCursor(NULL);
			return 1;
		}
		break;

	case WM_KEYDOWN:
		// L[͂̏
		switch(wParam)
		{
		case VK_ESCAPE:	// [ESCAPE]L[ŃEChE
			PostMessage(hWnd, WM_CLOSE, 0, 0);
			break;

		case 'W':	// ʃ[h̐؂ւ
			ChangeDisplayMode();
			break;
		}
		break;

	case WM_COMMAND:
		// Iꂽj[s
		switch (LOWORD(wParam))
		{
		case ID_FILE_EXIT:
			DestroyWindow(hWnd);
			return 0;
		}
		break;
	}

	// ftHg
	return DefWindowProc(hWnd, msg, wParam, lParam);
}

/*--------------------------------------------
	ACh̏
--------------------------------------------*/
bool AppIdle(void)
{
	if (!g_pD3D || !g_pD3DDevice)
		return false;

	if (!g_bActive)
		return true;

	// foCX̕
	HRESULT hr;
	if (g_bDeviceLost)
	{
		Sleep(100);	// 0.1b҂

		// foCXԂ̃`FbN
		hr  = g_pD3DDevice->TestCooperativeLevel();
		if (FAILED(hr))
		{
			if (hr == D3DERR_DEVICELOST)
				return true;  // foCX͂܂Ă

			if (hr != D3DERR_DEVICENOTRESET)
				return false; // \ʃG[

			CleanupD3DObject(); // Direct3DŊǗĂȂ\[XJ
			hr = g_pD3DDevice->Reset(&g_D3DPP); // ݂
			if (FAILED(hr))
			{
				if (hr == D3DERR_DEVICELOST)
					return true; // foCX͂܂Ă

				DXTRACE_ERR(L"AppIdle Reset", hr);
				return false; // foCX̕Ɏs
			}
			hr = InitD3DObject();  // JDirect3DŊǗĂȂ\[XĎ擾
			if (FAILED(hr))
			{
				DXTRACE_ERR(L"AppIdle InitD3DObject", hr);
				return false;
			}
		}
		// foCX
		g_bDeviceLost = false;
	}

	// ʂ̍XV
	hr = Render();
	if (hr == D3DERR_DEVICELOST)
		g_bDeviceLost = true;	// foCX̏
	else if (FAILED(hr))
		return false;

	return true;
}

/*--------------------------------------------
	C
---------------------------------------------*/
int WINAPI wWinMain(HINSTANCE hInst, HINSTANCE hPrevInst, LPWSTR lpCmdLine, int nCmdShow)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );

	// AvP[VɊւ鏉
	HRESULT hr = InitApp(hInst);
	if (FAILED(hr))
	{
		DXTRACE_ERR(L"WinMain InitApp", hr);
		return 0;
	}

	// DirectX Graphics̏
	hr = InitDXGraphics();
	if (FAILED(hr))
		DXTRACE_ERR(L"WinMain InitDXGraphics", hr);
	else
	{
		// D3DɊǗȂIuWFNg̏
		hr = InitD3DObject();
		if (FAILED(hr))
		{
			DXTRACE_ERR(L"WinMain InitD3DObject", hr);
			DestroyWindow(g_hWindow);
		}
	}

	// bZ[WE[v
	MSG msg;
	do
	{
		if (PeekMessage(&msg, 0, 0, 0, PM_REMOVE))
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
		else
		{
			// ACh
			if (!AppIdle())
				// G[ꍇCAvP[VI
				DestroyWindow(g_hWindow);
		}
	} while (msg.message != WM_QUIT);

	// AvP[V̏I
	CleanupApp();

	return (int)msg.wParam;
}

