/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample08.cpp
		ufoCX̍쐬DXUTCreateDeviceFromSettings֐gvOv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// *****************************************
// **** O[oϐ

// XvCg@\
LPD3DXSPRITE			g_pD3DXSprite = NULL;	// XvCg
LPDIRECT3DTEXTURE9		g_pD3DTexture = NULL;	// XvCgɎgeNX`
WCHAR g_SpriteFileName[MAX_PATH] = L"";			// XvCgɎg摜t@C

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// r[|[g̐ݒ
	D3DVIEWPORT9 vp;
	vp.X        = 0;
	vp.Y        = 0;
	vp.Width    = pBackBufferSurfaceDesc->Width;
	vp.Height   = pBackBufferSurfaceDesc->Height;
	vp.MinZ     = 0.0f;
	vp.MaxZ     = 1.0f;
	V_RETURN(pd3dDevice->SetViewport(&vp));

	// XvCgɎg摜t@Č
	V_RETURN(DXUTFindDXSDKMediaFileCch(g_SpriteFileName, MAX_PATH, L"canvas.dds"));

	// XvCgɕ\eNX`̏
	V_RETURN(D3DXCreateTextureFromFile(pd3dDevice, g_SpriteFileName, &g_pD3DTexture));

	// XvCg@\̏
	V_RETURN(D3DXCreateSprite(pd3dDevice, &g_pD3DXSprite));

	return hr;
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnLostDevice();
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	// XvCg̏
	if (g_pD3DXSprite)
		g_pD3DXSprite->OnResetDevice();

	return S_OK;
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// 擾IuWFNg̊J
	SAFE_RELEASE(g_pD3DXSprite);
	SAFE_RELEASE(g_pD3DTexture);
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// **  **
	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample08"); // EChE̍쐬

	// 쐬foCX̐ݒ
	DXUTDeviceSettings DeviceSettings;
	DeviceSettings.d3d9.AdapterOrdinal = D3DADAPTER_DEFAULT;
	DeviceSettings.d3d9.DeviceType     = D3DDEVTYPE_HAL;
	DeviceSettings.d3d9.AdapterFormat  = D3DFMT_X8R8G8B8;
	DeviceSettings.d3d9.BehaviorFlags  = D3DCREATE_HARDWARE_VERTEXPROCESSING;
	ZeroMemory(&DeviceSettings.d3d9.pp, sizeof(DeviceSettings.d3d9.pp));
	DeviceSettings.d3d9.pp.BackBufferWidth             = 0;
	DeviceSettings.d3d9.pp.BackBufferHeight            = 0;
	DeviceSettings.d3d9.pp.BackBufferFormat            = D3DFMT_UNKNOWN;
	DeviceSettings.d3d9.pp.BackBufferCount             = 1;
	DeviceSettings.d3d9.pp.MultiSampleType             = D3DMULTISAMPLE_NONE;
	DeviceSettings.d3d9.pp.MultiSampleQuality          = 0;
	DeviceSettings.d3d9.pp.SwapEffect                  = D3DSWAPEFFECT_DISCARD;
	DeviceSettings.d3d9.pp.hDeviceWindow               = DXUTGetHWND();
	DeviceSettings.d3d9.pp.Windowed	                  = TRUE;
	DeviceSettings.d3d9.pp.EnableAutoDepthStencil      = FALSE;
	DeviceSettings.d3d9.pp.AutoDepthStencilFormat      = D3DFMT_UNKNOWN;
	DeviceSettings.d3d9.pp.Flags                       = 0;
	DeviceSettings.d3d9.pp.FullScreen_RefreshRateInHz  = 0;
	DeviceSettings.d3d9.pp.PresentationInterval        = D3DPRESENT_INTERVAL_IMMEDIATE;

	// w肵ݒɍł߂ݒŃfoCX
	DXUTCreateDeviceFromSettings(&DeviceSettings, false);
	
	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
