/*----------------------------------------------------------
	Direct3D9Tv
		EMicrosoft DirectX SDK (June 2010)
		EVisual Studio 2010 Express
		EWindows XP or Windows Vista or Windows 7
		E_/sNZEVF[_2.0
		Ή

	D3D9Sample13.cpp
		uDXUTDirectSound@\gvOv
--------------------------------------------------------------*/

#define D3DXFX_LARGEADDRESS_HANDLE	// D3DXHANDLEp[^ɓnȂ
#define DXUT_AUTOLIB		// DXUTŕKvȃCu(dsound.libȊO)IɃN
#include "DXUT.h"			// DXUTg
#include "SDKmisc.h"		// DXUT Optionalg
#include "DXUTgui.h"		// DXUT OptionalGUIg
#include "SDKsound.h"		// DXUT OptionalCSoundNXg
#include "resource.h"

// DXUT̃CuN
#if defined(DEBUG) || defined(_DEBUG)
#pragma comment( lib, "..\\Debug\\DXUT.lib" )
#pragma comment( lib, "..\\Debug\\DXUTOpt.lib" )
#else
#pragma comment( lib, "..\\Release\\DXUT.lib" )
#pragma comment( lib, "..\\Release\\DXUTOpt.lib" )
#endif

// DirectSoundg
#pragma comment( lib, "dsound.lib" )

// *****************************************
// **** O[oϐ

// DirectSound@\
CSoundManager   *g_pDSound = NULL;				// IDirectSound8C^[tFCX̊ǗNX
CSound          *g_pDSoundBuffer1 = NULL;		// ĐTEhEobt@̊ǗNX@
CSound          *g_pDSoundBuffer2 = NULL;		// ĐTEhEobt@̊ǗNXA
WCHAR   g_DSoundFileName1[MAX_PATH] = L"";		// ĐftHgWAVt@C@
WCHAR   g_DSoundFileName2[MAX_PATH] = L"";		// ĐftHgWAVt@CA

// *****************************************
// **** O[oϐ(GUI@\)

// GUI\[XǗ
CDXUTDialogResourceManager	g_DialogResourceManager; // _CAÕ\[XǗ

// _CAO@(ݒBE)
enum {  ID_STATIC1, ID_PLAY1, ID_LOOP1, ID_STOP1,	// Rg[ID(t@CAĐ/ꎞ~, [v, ~)
		ID_STATIC2, ID_PLAY2, ID_LOOP2, ID_STOP2 };	// Rg[ID(t@CAĐ/ꎞ~, [v, ~)
CDXUTDialog  g_SampleUI;   // _CAO@

// *****************************************
// **** GUI֘Å֐

// _CAOĂяoR[obN֐
void CALLBACK DXUTCallbackGUIEvent(UINT nEvent, int nControlID, CDXUTControl* pControl, void* pUserContext)
{
	HRESULT hr;
	CSound *SBuffer = NULL;
	bool Loop = false;
	enum { PLAY, STOP } Type;

	switch (nControlID)
	{
	// _CAO@(ݒ_CAO)
	case ID_PLAY1:			// Đ܂͈ꎞ~
		Type = PLAY;
		SBuffer = g_pDSoundBuffer1;
		Loop = g_SampleUI.GetCheckBox(ID_LOOP1)->GetChecked();
		break;

	case ID_STOP1:			// ~
		Type = STOP;
		SBuffer = g_pDSoundBuffer1;
		break;

	case ID_PLAY2:			// Đ܂͈ꎞ~
		Type = PLAY;
		SBuffer = g_pDSoundBuffer2;
		Loop = g_SampleUI.GetCheckBox(ID_LOOP2)->GetChecked();
		break;

	case ID_STOP2:			// ~
		Type = STOP;
		SBuffer = g_pDSoundBuffer2;
		break;
	}

	if (SBuffer == NULL)
		return;

	if (Type == PLAY) {
		// ĐȂꎞ~
		if (SBuffer->IsSoundPlaying())
			SBuffer->Stop();
		// ȊÔƂ͍Đ
		else {
			V(SBuffer->Play(0, Loop ? DSBPLAY_LOOPING : 0L));
		}
	}
	else if (Type == STOP) {
		// ~
		SBuffer->Stop();
		SBuffer->Reset();
	}
}

// *****************************************
// **** foCX쐬֘ÃR[obN֐

// foCX쐬̏(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceCreated(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9CreateDevice( pd3dDevice ) );

	return hr;
}

// *****************************************
// **** bZ[W֘ÃR[obN֐

// EChEEbZ[W̏(R[obN֐)
LRESULT CALLBACK DXUTCallbackMsgProc(
			HWND hWnd, UINT uMsg, WPARAM wParam, LPARAM lParam, bool *pbNoFurtherProcessing, void* pUserContext)
{
	// GUI\[XǗ
	*pbNoFurtherProcessing = g_DialogResourceManager.MsgProc( hWnd, uMsg, wParam, lParam );
	if( *pbNoFurtherProcessing )
		return 0;

	// _CAO@̃bZ[W
	*pbNoFurtherProcessing = g_SampleUI.MsgProc(hWnd, uMsg, wParam, lParam);
	if(*pbNoFurtherProcessing)
		return 0;

	// DirectSound֘A
	HRESULT hr;
	switch (uMsg) {
		// EChE쐬̏
		case WM_CREATE:
			g_pDSound = new CSoundManager();
			V_RETURN(g_pDSound->Initialize(hWnd, DSSCL_PRIORITY));
			// XeIA22.05KHzA16rbg
			V_RETURN(g_pDSound->SetPrimaryBufferFormat(2, 22050, 16));

			// ĐWavet@Č
			V_RETURN(DXUTFindDXSDKMediaFileCch(g_DSoundFileName1, MAX_PATH, L"Sound1.wav"));
			V_RETURN(DXUTFindDXSDKMediaFileCch(g_DSoundFileName2, MAX_PATH, L"Sound2.wav"));

			// TEhEobt@쐬
			V_RETURN(g_pDSound->Create(&g_pDSoundBuffer1, g_DSoundFileName1, 0, GUID_NULL));
			V_RETURN(g_pDSound->Create(&g_pDSoundBuffer2, g_DSoundFileName2, 0, GUID_NULL));
			break;

		// EChE폜̏
		case WM_DESTROY:
			SAFE_DELETE(g_pDSoundBuffer1);
			SAFE_DELETE(g_pDSoundBuffer2);
			SAFE_DELETE(g_pDSound);
			break;
	};

	*pbNoFurtherProcessing = false;  // t[[NŃbZ[W
	return 0;
}

// *****************************************
// **** V[`֘ÃR[obN֐

// V[̍XV(R[obN֐)
void CALLBACK DXUTCallbackFrameMove(
		double fTime, float fElapsedTime, void* pUserContext)
{
	// {^̃LvVݒ(Đ́uꎞ~vA~́uĐv)
	if (g_pDSoundBuffer1) {
		g_SampleUI.GetButton(ID_PLAY1)->SetText(
			g_pDSoundBuffer1->IsSoundPlaying() ? L"ꎞ~" : L"Đ");
	}

	if (g_pDSoundBuffer2) {
		g_SampleUI.GetButton(ID_PLAY2)->SetText(
			g_pDSoundBuffer2->IsSoundPlaying() ? L"ꎞ~" : L"Đ");
	}
}

// V[̕`(R[obN֐)
void CALLBACK DXUTCallbackFrameRender(
		LPDIRECT3DDEVICE9 pd3dDevice, double fTime, float fElapsedTime, void* pUserContext)
{
	// V[̃NA
	pd3dDevice->Clear(0, NULL, D3DCLEAR_TARGET, D3DCOLOR_XRGB(0, 0, 255), 1.0f, 0);

	// V[̕`Jn
	if (SUCCEEDED(pd3dDevice->BeginScene()))
	{
		// _CAO`
		g_SampleUI.OnRender(fElapsedTime);

		// V[̕`I
		pd3dDevice->EndScene();
	}
}

// *****************************************
// **** foCX̏֘ÃR[obN֐

// foCX̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceLost(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9LostDevice();
}

// foCX̃XgA(R[obN֐)
HRESULT CALLBACK DXUTCallbackDeviceReset(
			LPDIRECT3DDEVICE9 pd3dDevice, const D3DSURFACE_DESC *pBackBufferSurfaceDesc, void* pUserContext)
{
	HRESULT hr;

	// GUI\[XǗ
	V_RETURN( g_DialogResourceManager.OnD3D9ResetDevice() );

	// _CAO̔zu
	g_SampleUI.SetLocation(pBackBufferSurfaceDesc->Width  - 150, 
							pBackBufferSurfaceDesc->Height - 210);      // _CAO̍W(-150, -210)
	g_SampleUI.SetSize(150, 210);     // _CAȎ傫(150~210)

	return hr;	// I
}

// *****************************************
// **** foCX폜֘ÃR[obN֐

// foCX폜̏(R[obN֐)
void CALLBACK DXUTCallbackDeviceDestroyed(void* pUserContext)
{
	// GUI\[XǗ
	g_DialogResourceManager.OnD3D9DestroyDevice();
}

// *****************************************
// WinMain֐ƃAvP[V֘Ȁ

// AvP[V֘Ȁ
void InitApp(void)
{
	// GUI\[XǗ(_CAȌ)
	g_SampleUI.Init( &g_DialogResourceManager );

	// Windows 2000pɓ{tHgݒ(Vista,XPł͕sv)B
	g_SampleUI.SetFont( 0, L"lr SVbN", 14, FW_NORMAL );

	// GUIRg[̃bZ[W󂯎R[obN֐_CAOɓo^
	g_SampleUI.SetCallback(DXUTCallbackGUIEvent);

	// GUIRg[_CAOɓo^
	int iY = 0;
	g_SampleUI.AddStatic(ID_STATIC1, L"Sound1.wav", 10, iY,       125, 22);
	g_SampleUI.AddButton(ID_PLAY1, L"Đ",         10, iY += 24, 125, 22);
	g_SampleUI.AddCheckBox(ID_LOOP1, L"[vĐ", 10, iY += 24, 125, 22);
	g_SampleUI.AddButton(ID_STOP1, L"~",         10, iY += 24, 125, 22);
	iY += 10;
	g_SampleUI.AddStatic(ID_STATIC2, L"Sound2.wav", 10, iY += 24, 125, 22);
	g_SampleUI.AddButton(ID_PLAY2, L"Đ",         10, iY += 24, 125, 22);
	g_SampleUI.AddCheckBox(ID_LOOP2, L"[vĐ", 10, iY += 24, 125, 22);
	g_SampleUI.AddButton(ID_STOP2, L"~",         10, iY += 24, 125, 22);
}

// **** WinMain֐
int WINAPI wWinMain(HINSTANCE, HINSTANCE, LPWSTR, int)
{
	// fobO q[v }l[Wɂ郁蓖Ă̒ǐՕ@ݒ
#if defined(DEBUG) || defined(_DEBUG)
	_CrtSetDbgFlag( _CRTDBG_ALLOC_MEM_DF | _CRTDBG_LEAK_CHECK_DF );
#endif

	// ** R[obN֐̓o^ **
	// foCX쐬̏
	DXUTSetCallbackD3D9DeviceCreated(DXUTCallbackDeviceCreated);
	// EChEEbZ[W̏
	DXUTSetCallbackMsgProc(DXUTCallbackMsgProc);
	// V[̍XV
	DXUTSetCallbackFrameMove(DXUTCallbackFrameMove);
	// V[̕`
	DXUTSetCallbackD3D9FrameRender(DXUTCallbackFrameRender);
	// foCX̏
	DXUTSetCallbackD3D9DeviceLost(DXUTCallbackDeviceLost);
	// foCX̃XgA
	DXUTSetCallbackD3D9DeviceReset(DXUTCallbackDeviceReset);
	// foCX폜̏
	DXUTSetCallbackD3D9DeviceDestroyed(DXUTCallbackDeviceDestroyed);

	// tXN[E[hŃ}EXEJ[\\
	DXUTSetCursorSettings(true, true);

	// **  **
	InitApp();				// AvP[V֘Ȁ

	DXUTInit(true, true);                     // TvEt[[N̏
	DXUTSetHotkeyHandling(true);              // zbgEL[̐ݒ
	DXUTCreateWindow(L"Direct3D 9 Sample13"); // EChE̍쐬

	DXUTCreateDevice(true, 640, 480);  // foCX̍쐬

	// ** CE[v **
	DXUTMainLoop();    // bZ[WE[vs

	return DXUTGetExitCode();  // I
}
